/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl.command;

import com.google.gson.JsonElement;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Locale;
import java.util.function.BiFunction;
import net.darkhax.bookshelf.common.api.commands.IEnumCommand;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public enum HandCommand implements IEnumCommand
{
    STRING((stack, level) -> TextHelper.copyText(stack.toString())),
    INGREDIENT(HandCommand.fromCodec(MapCodecs.INGREDIENT.get(), (stack, level) -> Ingredient.of((ItemStack[])new ItemStack[]{stack}))),
    STACK_JSON(HandCommand.fromCodec(MapCodecs.ITEM_STACK.get(), (stack, level) -> stack));

    private final ItemFormat format;

    private HandCommand(ItemFormat format) {
        this.format = format;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> this.format.formatItem(living.getMainHandItem(), source.getLevel()), false);
        }
        return 1;
    }

    private static <T> ItemFormat fromCodec(Codec<T> codec, BiFunction<ItemStack, ServerLevel, T> mapper) {
        return (stack, level) -> {
            if (stack.isEmpty()) {
                return Component.translatable((String)"commands.bookshelf.hand.error.not_air").withStyle(ChatFormatting.RED);
            }
            Object value = mapper.apply(stack, level);
            JsonElement json = (JsonElement)codec.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)level.registryAccess()), value).getOrThrow();
            return TextHelper.copyText(Constants.GSON_PRETTY.toJson(json));
        };
    }

    @Override
    public String getCommandName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> build(CommandBuildContext context) {
        return CommandHelper.buildFromEnum("hand", HandCommand.class);
    }

    static interface ItemFormat {
        public Component formatItem(ItemStack var1, ServerLevel var2);
    }
}

