/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import net.darkhax.bookshelf.common.api.commands.PermissionLevel;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EnchantCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> build(CommandBuildContext context) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.literal((String)"enchant").requires((Predicate)PermissionLevel.GAMEMASTER);
        root.then(Commands.argument((String)"enchantment", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.ENCHANTMENT)).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(EnchantCommand::enchantItem)));
        root.then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"enchantment", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.ENCHANTMENT)).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(EnchantCommand::enchantItem))));
        return root;
    }

    private static int enchantItem(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity target = CommandHelper.hasArgument("target", ctx) ? EntityArgument.getEntity(ctx, (String)"target") : ((CommandSourceStack)ctx.getSource()).getEntity();
        Holder.Reference enchantment = ResourceArgument.getEnchantment(ctx, (String)"enchantment");
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if (livingTarget.getMainHandItem().isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"commands.bookshelf.hand.error.not_air"));
                return 0;
            }
            livingTarget.getMainHandItem().enchant((Holder)enchantment, level);
            return 1;
        }
        return 0;
    }
}

