/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.PhysicalSide;
import net.darkhax.bookshelf.common.api.annotation.OnlyFor;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.api.text.unit.Units;
import net.darkhax.bookshelf.common.mixin.access.client.AccessorFontManager;
import net.darkhax.bookshelf.common.mixin.access.client.AccessorMinecraft;
import net.darkhax.bookshelf.common.mixin.access.entity.AccessorEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class TextHelper {
    public static MutableComponent fromResourceLocation(@Nullable String prefix, @Nullable String suffix, ResourceLocation location, Object ... args) {
        StringBuilder builder = new StringBuilder();
        if (prefix != null) {
            builder.append(prefix).append(".");
        }
        builder.append(location.getNamespace()).append(".").append(location.getPath());
        if (suffix != null) {
            builder.append(".").append(suffix);
        }
        return Component.translatable((String)builder.toString(), (Object[])args);
    }

    public static MutableComponent formatDuration(int ticks) {
        return TextHelper.formatDuration(ticks, true, 1.0f);
    }

    public static MutableComponent formatDuration(int ticks, Level level) {
        return TextHelper.formatDuration(ticks, true, level);
    }

    public static MutableComponent formatDuration(int ticks, boolean includeHover, Level level) {
        return TextHelper.formatDuration(ticks, includeHover, level.tickRateManager().tickrate());
    }

    public static MutableComponent formatDuration(int ticks, boolean showTicksOnHover, float tickRate) {
        MutableComponent timeText = Component.literal((String)StringUtil.formatTickDuration((int)ticks, (float)tickRate));
        if (showTicksOnHover) {
            timeText = Units.TICK.format(ticks);
        }
        return timeText;
    }

    public static MutableComponent withHover(Component base, Component hover) {
        return TextHelper.withHover(base, new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)hover));
    }

    public static MutableComponent withHover(Component base, Entity hover) {
        return TextHelper.withHover(base, TextHelper.hoverEvent(hover));
    }

    public static MutableComponent withHover(Component base, ItemStack hover) {
        return TextHelper.withHover(base, new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(hover)));
    }

    public static MutableComponent withHover(Component base, HoverEvent hover) {
        return TextHelper.mutable(base).withStyle(style -> style.withHoverEvent(hover));
    }

    public static HoverEvent hoverEvent(Entity entity) {
        if (entity instanceof AccessorEntity) {
            AccessorEntity access = (AccessorEntity)entity;
            return access.bookshelf$createHoverEvent();
        }
        return new HoverEvent(HoverEvent.Action.SHOW_ENTITY, (Object)new HoverEvent.EntityTooltipInfo(entity.getType(), entity.getUUID(), entity.getName()));
    }

    public static MutableComponent mutable(Component component) {
        MutableComponent mutable;
        return component instanceof MutableComponent ? (mutable = (MutableComponent)component) : component.copy();
    }

    public static Component applyFont(Component text, ResourceLocation font) {
        if (text == CommonComponents.EMPTY) {
            return text;
        }
        MutableComponent modified = TextHelper.mutable(text);
        modified.withStyle(style -> style.withFont(font));
        modified.getSiblings().forEach(sib -> TextHelper.applyFont(sib, font));
        return modified;
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    public static MutableComponent lookupTranslationWithAlias(ResourceLocation id, String ... keys) {
        for (String key : keys) {
            MutableComponent lookupResult = TextHelper.lookupTranslation(key.formatted(id.getNamespace(), id.getPath()), new Object[0]);
            if (lookupResult == null) continue;
            return lookupResult;
        }
        return null;
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    public static MutableComponent lookupTranslationWithAlias(String[] keys, Object ... params) {
        for (String key : keys) {
            MutableComponent lookupResult = TextHelper.lookupTranslation(key, params);
            if (lookupResult == null) continue;
            return lookupResult;
        }
        return null;
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    public static MutableComponent lookupTranslation(String key, Object ... args) {
        return TextHelper.lookupTranslation(key, (String s, Object[] o) -> null, args);
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    public static MutableComponent lookupTranslation(String key, MutableComponent fallback, Object ... args) {
        return TextHelper.lookupTranslation(key, (String s, Object[] o) -> fallback, args);
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    public static MutableComponent lookupTranslation(String key, @Nullable BiFunction<String, Object[], MutableComponent> fallback, Object ... args) {
        if (!Services.PLATFORM.isPhysicalClient()) {
            throw new IllegalStateException("Text can not be translated on the server.");
        }
        return I18n.exists((String)key) ? Component.translatable((String)key, (Object[])args) : (fallback != null ? fallback.apply(key, args) : null);
    }

    public static MutableComponent copyText(String text) {
        return TextHelper.setCopyText(Component.literal((String)text), text);
    }

    public static MutableComponent setCopyText(MutableComponent component, String copy) {
        return component.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, copy)));
    }

    public static MutableComponent join(Component separator, Component ... toJoin) {
        return TextHelper.join(separator, Arrays.stream(toJoin).iterator());
    }

    public static MutableComponent join(Component separator, Collection<Component> toJoin) {
        return TextHelper.join(separator, toJoin.iterator());
    }

    public static MutableComponent join(Component separator, Iterator<Component> toJoin) {
        MutableComponent joined = Component.literal((String)"");
        while (toJoin.hasNext()) {
            joined.append(toJoin.next());
            if (!toJoin.hasNext()) continue;
            joined.append(separator);
        }
        return joined;
    }

    public static Set<String> getPossibleMatches(String input, Iterable<String> candidates) {
        return TextHelper.getPossibleMatches(input, candidates, Integer.MAX_VALUE);
    }

    public static Set<String> getPossibleMatches(String input, Iterable<String> candidates, int threshold) {
        HashSet<String> bestMatches = new HashSet<String>();
        int distance = threshold;
        for (String candidate : candidates) {
            int currentDistance = StringUtils.getLevenshteinDistance((CharSequence)input, (CharSequence)candidate);
            if (currentDistance < distance) {
                distance = currentDistance;
                bestMatches.clear();
                bestMatches.add(candidate);
                continue;
            }
            if (currentDistance != distance) continue;
            bestMatches.add(candidate);
        }
        return bestMatches;
    }

    public static <T> String formatCollection(Collection<T> collection) {
        return TextHelper.formatCollection(collection, entry -> "\"" + entry.toString() + "\"", ", ");
    }

    public static <T> String formatCollection(Collection<T> collection, Function<T, String> formatter, String delimiter) {
        return collection.size() == 1 ? formatter.apply(collection.stream().findFirst().get()) : collection.stream().map(formatter).collect(Collectors.joining(delimiter));
    }

    @OnlyFor(value=PhysicalSide.CLIENT)
    public static Set<ResourceLocation> getRegisteredFonts() {
        if (!Services.PLATFORM.isPhysicalClient()) {
            return Collections.emptySet();
        }
        return ((AccessorFontManager)((AccessorMinecraft)Minecraft.getInstance()).bookshelf$getFontManager()).bookshelf$getFonts().keySet();
    }
}

