/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MathsHelper {
    public static final Random RANDOM = new SecureRandom();
    public static final RandomSource RANDOM_SOURCE = RandomSource.create();
    public static final DecimalFormat DECIMAL_2 = new DecimalFormat("##.##");

    public static boolean inRange(double min, double max, double value) {
        return value <= max && value >= min;
    }

    public static double distance(Vec3 first, Vec3 second) {
        double distanceX = first.x - second.x;
        double distanceY = first.y - second.y;
        double distanceZ = first.z - second.z;
        return Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
    }

    public static double round(double value, int places) {
        return value >= 0.0 && places > 0 ? BigDecimal.valueOf(value).setScale(places, RoundingMode.HALF_UP).doubleValue() : value;
    }

    public static int nextInt(Random rng, int min, int max) {
        return rng.nextInt(max - min + 1) + min;
    }

    public static int nextInt(RandomSource rng, int min, int max) {
        return rng.nextIntBetweenInclusive(min, max);
    }

    public static boolean percentChance(double chance) {
        return Math.random() < chance;
    }

    public static float average(int ... values) {
        return (float)Arrays.stream(values).sum() / (float)values.length;
    }

    public static float percentage(int value, int total) {
        return (float)value / (float)total;
    }

    public static double pixelSize(int pixels) {
        return (double)pixels / 16.0;
    }

    public static AABB boundsForPixels(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new AABB(MathsHelper.pixelSize(minX), MathsHelper.pixelSize(minY), MathsHelper.pixelSize(minZ), MathsHelper.pixelSize(maxX), MathsHelper.pixelSize(maxY), MathsHelper.pixelSize(maxZ));
    }

    public static Map<Direction, VoxelShape> createHorizontalShapes(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        EnumMap<Direction, VoxelShape> shapes = new EnumMap<Direction, VoxelShape>(Direction.class);
        Direction.Plane.HORIZONTAL.forEach(dir -> shapes.put((Direction)dir, MathsHelper.rotateShape(dir, minX, minY, minZ, maxX, maxY, maxZ)));
        return shapes;
    }

    public static VoxelShape rotateShape(Direction facing, double x1, double y1, double z1, double x2, double y2, double z2) {
        return switch (facing) {
            case Direction.NORTH -> Block.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            case Direction.EAST -> Block.box((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            case Direction.SOUTH -> Block.box((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            case Direction.WEST -> Block.box((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            default -> throw new IllegalArgumentException("Can not rotate face in direction " + facing.name());
        };
    }

    public static BlockPos randomOffsetHorizontal(BlockPos startPos, RandomSource rng, int range) {
        return MathsHelper.randomOffset(startPos, rng, range, 0, range);
    }

    public static BlockPos randomOffset(BlockPos startPos, RandomSource rng, int rangeX, int rangeY, int rangeZ) {
        if (rangeX < 0 || rangeY < 0 || rangeZ < 0) {
            throw new IllegalArgumentException("Cannot offset position by '" + rangeX + ", " + rangeY + ", " + rangeZ + "'. Range must be positive!");
        }
        int offsetX = rangeX != 0 ? rng.nextIntBetweenInclusive(-rangeX, rangeX) : 0;
        int offsetY = rangeY != 0 ? rng.nextIntBetweenInclusive(-rangeY, rangeY) : 0;
        int offsetZ = rangeZ != 0 ? rng.nextIntBetweenInclusive(-rangeZ, rangeZ) : 0;
        return startPos.offset(offsetX, offsetY, offsetZ);
    }
}

