/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import net.darkhax.bookshelf.api.registry.IRegistryReader;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class SerializerRegistryEntry<T>
implements ISerializer<T> {
    private final IRegistryReader<T> registry;

    public SerializerRegistryEntry(IRegistryReader<T> registry) {
        this.registry = registry;
    }

    @Override
    public T fromJSON(JsonElement json) {
        ResourceLocation id = Serializers.RESOURCE_LOCATION.fromJSON(json);
        return this.registry.get(id);
    }

    @Override
    public JsonElement toJSON(T toWrite) {
        return Serializers.RESOURCE_LOCATION.toJSON(this.registry.getId(toWrite));
    }

    @Override
    public T fromByteBuf(FriendlyByteBuf buffer) {
        ResourceLocation id = Serializers.RESOURCE_LOCATION.fromByteBuf(buffer);
        return this.registry.get(id);
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, T toWrite) {
        Serializers.RESOURCE_LOCATION.toByteBuf(buffer, this.registry.getId(toWrite));
    }

    @Override
    public Tag toNBT(T toWrite) {
        return Serializers.RESOURCE_LOCATION.toNBT(this.registry.getId(toWrite));
    }

    @Override
    public T fromNBT(Tag nbt) {
        return this.registry.get(Serializers.RESOURCE_LOCATION.fromNBT(nbt));
    }
}

