/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.api.util.MathsHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class EntityHelper {
    private static final Map<EntityType<?>, Tuple<Integer, Integer>> eggColorCache = new HashMap();

    public static double getDistanceFromEntity(Entity firstEntity, Entity secondEntity) {
        return MathsHelper.getDistanceBetweenPoints(firstEntity.m_20182_(), secondEntity.m_20182_());
    }

    public static double getDistaceFromPos(Entity entity, BlockPos pos) {
        return MathsHelper.getDistanceBetweenPoints(entity.m_20182_(), Vec3.m_82512_((Vec3i)pos));
    }

    public static void pushTowards(Entity entityToMove, Direction direction, double force) {
        EntityHelper.pushTowards(entityToMove, entityToMove.m_142538_().m_5484_(direction.m_122424_(), 1), force);
    }

    public static void pushTowards(Entity entityToMove, BlockPos pos, double force) {
        double distanceZ;
        double distanceY;
        BlockPos entityPos = entityToMove.m_142538_();
        double distanceX = (double)pos.m_123341_() - (double)entityPos.m_123341_();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)pos.m_123342_() - (double)entityPos.m_123342_()) * distanceY + (distanceZ = (double)pos.m_123343_() - (double)entityPos.m_123343_()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.m_20256_(new Vec3(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static void pushTowards(Entity entityToMove, Entity destination, double force) {
        double distanceZ;
        double distanceY;
        double distanceX = destination.m_20185_() - entityToMove.m_20185_();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = destination.m_20186_() - entityToMove.m_20186_()) * distanceY + (distanceZ = destination.m_20189_() - entityToMove.m_20189_()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.m_20256_(new Vec3(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static void pushTowardsDirection(Entity entityToMove, Direction direction, double force) {
        double distanceZ;
        double distanceY;
        BlockPos entityPos = entityToMove.m_142538_();
        BlockPos destination = entityToMove.m_142538_().m_5484_(direction.m_122424_(), 1);
        double distanceX = (double)destination.m_123341_() - (double)entityPos.m_123341_();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)destination.m_123342_() - (double)entityPos.m_123342_()) * distanceY + (distanceZ = (double)destination.m_123343_() - (double)entityPos.m_123343_()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.m_20256_(new Vec3(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static boolean areEntitiesCloseEnough(Entity firstEntity, Entity secondEntity, double maxDistance) {
        return EntityHelper.getDistanceFromEntity(firstEntity, secondEntity) < maxDistance * maxDistance;
    }

    public static <T extends Entity> List<T> getEntitiesInArea(Class<T> entityClass, Level world, BlockPos pos, int range) {
        return EntityHelper.getEntitiesInArea(entityClass, world, pos, (float)range);
    }

    public static <T extends Entity> List<T> getEntitiesInArea(Class<T> entityClass, Level world, BlockPos pos, float range) {
        return world.m_45976_(entityClass, new AABB(pos.m_142022_((double)(-range), (double)(-range), (double)(-range)), pos.m_142022_((double)(range + 1.0f), (double)(range + 1.0f), (double)(range + 1.0f))));
    }

    public static boolean isWearingFullSet(Mob living, Class<Item> armorClass) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armor;
            if (!slot.m_20743_().equals((Object)EquipmentSlot.Type.ARMOR) || !(armor = living.m_6844_(slot)).m_41619_() && armor.m_41720_().getClass().equals(armorClass)) continue;
            return false;
        }
        return true;
    }

    public static HitResult rayTrace(LivingEntity entity, double length, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        Vec3 startingPosition = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_());
        Vec3 lookVector = entity.m_20154_();
        Vec3 endingPosition = startingPosition.m_82520_(lookVector.f_82479_ * length, lookVector.f_82480_ * length, lookVector.f_82481_ * length);
        return entity.f_19853_.m_45547_(new ClipContext(startingPosition, endingPosition, blockMode, fluidMode, (Entity)entity));
    }

    public static boolean isAffectedByFire(LivingEntity toCheck) {
        return !toCheck.m_5825_() && !toCheck.m_21023_(MobEffects.f_19607_);
    }

    public static void clearEffects(LivingEntity entity, boolean removePositive, boolean removeNegative) {
        HashSet<MobEffect> toClear = new HashSet<MobEffect>();
        for (MobEffectInstance mobEffectInstance : entity.m_21220_()) {
            boolean isGood = mobEffectInstance.m_19544_().m_19486_();
            if ((!isGood || !removePositive) && (isGood || !removeNegative)) continue;
            toClear.add(mobEffectInstance.m_19544_());
        }
        for (MobEffect mobEffect : toClear) {
            entity.m_21195_(mobEffect);
        }
    }

    public static Tuple<Integer, Integer> getEggColors(EntityType<?> type) {
        return eggColorCache.computeIfAbsent(type, key -> {
            SpawnEggItem item = SpawnEggItem.m_43213_((EntityType)key);
            if (item != null) {
                return new Tuple((Object)item.m_43211_(0), (Object)item.m_43211_(1));
            }
            return new Tuple((Object)0, (Object)0);
        });
    }
}

