/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.serialization.ISerializer;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class SerializerEnchantmentData
implements ISerializer<EnchantmentData> {
    public static final ISerializer<EnchantmentData> SERIALIZER = new SerializerEnchantmentData();

    private SerializerEnchantmentData() {
    }

    @Override
    public EnchantmentData read(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            Enchantment enchant = Serializers.ENCHANTMENT.read(obj.get("enchantment"));
            int level = JSONUtils.func_151203_m((JsonObject)obj, (String)"level");
            return new EnchantmentData(enchant, level);
        }
        throw new JsonParseException("Expected enchantment data to be a JSON object.");
    }

    @Override
    public JsonElement write(EnchantmentData toWrite) {
        JsonObject json = new JsonObject();
        json.add("enchantment", Serializers.ENCHANTMENT.write(toWrite.field_76302_b));
        json.addProperty("level", (Number)toWrite.field_76303_c);
        return json;
    }

    @Override
    public EnchantmentData read(PacketBuffer buffer) {
        Enchantment enchant = Serializers.ENCHANTMENT.read(buffer);
        int level = buffer.readInt();
        return new EnchantmentData(enchant, level);
    }

    @Override
    public void write(PacketBuffer buffer, EnchantmentData toWrite) {
        Serializers.ENCHANTMENT.write(buffer, toWrite.field_76302_b);
        buffer.writeInt(toWrite.field_76303_c);
    }

    @Override
    public INBT writeNBT(EnchantmentData toWrite) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("enchantment", Serializers.ENCHANTMENT.writeNBT(toWrite.field_76302_b));
        tag.func_218657_a("level", Serializers.INT.writeNBT(toWrite.field_76303_c));
        return tag;
    }

    @Override
    public EnchantmentData read(INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            CompoundNBT tag = (CompoundNBT)nbt;
            Enchantment ench = Serializers.ENCHANTMENT.read(tag.func_74781_a("enchantment"));
            int level = Serializers.INT.read(tag.func_74781_a("level"));
            return new EnchantmentData(ench, level);
        }
        throw new IllegalArgumentException("Expected NBT to be a compound tag. Class was " + nbt.getClass() + " with ID " + nbt.func_74732_a() + " instead.");
    }
}

