/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest;

import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.darkhax.bookshelf.mixin.util.random.AccessorWeightedRandomList;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_4516;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_6302;

public class TestSerialization<T>
implements ITestable {
    private final String type;
    private final ISerializer<T> serializer;
    private final T singleton;
    private final T[] collection;
    private final BiPredicate<T, T> equality;

    public TestSerialization(String type, ISerializer<T> serializer, T ... collection) {
        this(type, (ISerializer<Object>)serializer, Objects::equals, (Object)collection[0], collection);
    }

    public TestSerialization(String type, ISerializer<T> serializer, BiPredicate<T, T> equality, T ... collection) {
        this(type, serializer, equality, collection[0], collection);
    }

    public TestSerialization(String type, ISerializer<T> serializer, BiPredicate<T, T> equality, T singleton, T ... collection) {
        this.type = type;
        this.serializer = serializer;
        this.equality = equality;
        this.singleton = singleton;
        this.collection = collection;
    }

    @class_6302
    public void testJsonSingleton(class_4516 helper) {
        JsonElement toJson = this.serializer.toJSON(this.singleton);
        T fromJson = this.serializer.fromJSON(toJson);
        if (!this.equality.test(this.singleton, fromJson)) {
            helper.method_35995("Singleton from" + this.type + " JSON does not match! a= " + this.singleton + " b= " + fromJson);
        } else {
            helper.method_36036();
        }
    }

    @class_6302
    public void testBytebufSingleton(class_4516 helper) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        this.serializer.toByteBuf(buffer, this.singleton);
        T fromBuffer = this.serializer.fromByteBuf(buffer);
        if (!this.equality.test(this.singleton, fromBuffer)) {
            helper.method_35995("Singleton from" + this.type + " ByteBuf does not match! a= " + this.singleton + " b= " + fromBuffer);
        } else {
            helper.method_36036();
        }
    }

    @class_6302
    public void testNbtSingleton(class_4516 helper) {
        class_2520 toNBT = this.serializer.toNBT(this.singleton);
        T fromNBT = this.serializer.fromNBT(toNBT);
        if (!this.equality.test(this.singleton, fromNBT)) {
            helper.method_35995("Singleton from" + this.type + " NBT does not match! a= " + this.singleton + " b= " + fromNBT);
        } else {
            helper.method_36036();
        }
    }

    @class_6302
    public void testJsonWeightedSingleton(class_4516 helper) {
        class_6008.class_6010 weightedSingleton = class_6008.method_34980(this.singleton, (int)14);
        JsonElement toJson = this.serializer.toJSONWeighted(weightedSingleton);
        class_6008.class_6010<T> fromJson = this.serializer.fromJSONWeighted(toJson);
        if (!weightedSingleton.method_34979().equals((Object)fromJson.method_34979())) {
            helper.method_35995("Weight for JSON does not match! a= " + weightedSingleton.method_34979() + " b= " + fromJson.method_34979());
        }
        if (!this.equality.test(this.singleton, fromJson.method_34983())) {
            helper.method_35995("Weighted Singleton from" + this.type + " JSON does not match! a= " + this.singleton + " b= " + fromJson.method_34983());
        } else {
            helper.method_36036();
        }
    }

    @class_6302
    public void testBytebufWeightedSingleton(class_4516 helper) {
        class_6008.class_6010 weightedSingleton = class_6008.method_34980(this.singleton, (int)14);
        class_2540 buffer = new class_2540(Unpooled.buffer());
        this.serializer.toByteBufWeighted(buffer, weightedSingleton);
        class_6008.class_6010<T> fromBuffer = this.serializer.fromByteBufWeighted(buffer);
        if (!weightedSingleton.method_34979().equals((Object)fromBuffer.method_34979())) {
            helper.method_35995("Weight for ByteBuf does not match! a= " + weightedSingleton.method_34979() + " b= " + fromBuffer.method_34979());
        }
        if (!this.equality.test(this.singleton, fromBuffer.method_34983())) {
            helper.method_35995("Weighted Singleton from" + this.type + " ByteBuf does not match! a= " + this.singleton + " b= " + fromBuffer.method_34983());
        } else {
            helper.method_36036();
        }
    }

    @class_6302
    public void testJsonOptionalSingleton(class_4516 helper) {
        Optional<T> original = Optional.ofNullable(this.singleton);
        JsonElement toJson = this.serializer.toJSONOptional(original);
        Optional<T> fromJson = this.serializer.fromJSONOptional(toJson);
        if (original.isPresent() && fromJson.isPresent() && !this.equality.test(original.get(), fromJson.get())) {
            helper.method_35995("Optional Singleton from" + this.type + " JSON does not match! a= " + original.get() + " b= " + fromJson.get());
        }
        if (original.isPresent() != fromJson.isPresent()) {
            helper.method_35995("Optional Singleton from " + this.type + " JSON availability mismatch. a= " + original.isPresent() + " b= " + fromJson.isPresent());
        } else {
            helper.method_36036();
        }
    }

    @class_6302
    public void testBytebufOptionalSingleton(class_4516 helper) {
        Optional<T> original = Optional.ofNullable(this.singleton);
        class_2540 buffer = new class_2540(Unpooled.buffer());
        this.serializer.toByteBufOptional(buffer, original);
        Optional<T> fromByteBuf = this.serializer.fromByteBufOptional(buffer);
        if (original.isPresent() && fromByteBuf.isPresent() && !this.equality.test(original.get(), fromByteBuf.get())) {
            helper.method_35995("Optional Singleton from" + this.type + " ByteBuf does not match! a= " + original.get() + " b= " + fromByteBuf.get());
        }
        if (original.isPresent() != fromByteBuf.isPresent()) {
            helper.method_35995("Optional Singleton from " + this.type + " ByteBuf availability mismatch. a= " + original.isPresent() + " b= " + fromByteBuf.isPresent());
        } else {
            helper.method_36036();
        }
    }

    @class_6302
    public void testJsonEmptyOptionalSingleton(class_4516 helper) {
        Optional original = Optional.empty();
        JsonElement toJson = this.serializer.toJSONOptional(original);
        Optional<T> fromJson = this.serializer.fromJSONOptional(toJson);
        if (original.isPresent() || fromJson.isPresent()) {
            helper.method_35995("Empty Optional Singleton from" + this.type + " JSON was not empty! a= " + original.isPresent() + " b= " + fromJson.isPresent());
        } else {
            helper.method_36036();
        }
    }

    @class_6302
    public void testBytebufEmptyOptionalSingleton(class_4516 helper) {
        Optional original = Optional.empty();
        class_2540 buffer = new class_2540(Unpooled.buffer());
        this.serializer.toByteBufOptional(buffer, original);
        Optional<T> fromByteBuf = this.serializer.fromByteBufOptional(buffer);
        if (original.isPresent() || fromByteBuf.isPresent()) {
            helper.method_35995("Empty Optional Singleton from" + this.type + " JSON was not empty! a= " + original.isPresent() + " b= " + fromByteBuf.isPresent());
        } else {
            helper.method_36036();
        }
    }

    @class_6302
    public void testJsonList(class_4516 helper) {
        List<T> list = List.of(this.collection);
        JsonElement written = this.serializer.toJSONList(list);
        List<T> read = this.serializer.fromJSONList(written);
        this.assertIterableEqual(helper, list, read);
    }

    @class_6302
    public void testBytebufList(class_4516 helper) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        List<T> list = List.of(this.collection);
        this.serializer.toByteBufList(buffer, list);
        List<T> read = this.serializer.fromByteBufList(buffer);
        this.assertIterableEqual(helper, list, read);
    }

    @class_6302
    public void testJsonSet(class_4516 helper) {
        Set<T> set = this.createSet();
        JsonElement written = this.serializer.toJSONSet(set);
        Set<T> read = this.serializer.fromJSONSet(written);
        this.assertIterableEqual(helper, set, read);
    }

    @class_6302
    public void testBytebufSet(class_4516 helper) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        Set<T> set = this.createSet();
        this.serializer.writeByteBufSet(buffer, set);
        Set<T> read = this.serializer.readByteBufSet(buffer);
        this.assertIterableEqual(helper, set, read);
    }

    @class_6302
    public void testJsonWeightedList(class_4516 helper) {
        class_6005<T> original = this.createWeightedList();
        JsonElement written = this.serializer.toJSONWeightedList(original);
        class_6005<T> read = this.serializer.fromJSONWeightedList(written);
        this.assertWeightedListEqual(helper, original, read);
    }

    @class_6302
    public void testBytebufWeightedList(class_4516 helper) {
        class_6005<T> original = this.createWeightedList();
        class_2540 buffer = new class_2540(Unpooled.buffer());
        this.serializer.toByteBufWeightedList(buffer, original);
        class_6005<T> read = this.serializer.fromByteBufWeightedList(buffer);
        this.assertWeightedListEqual(helper, original, read);
    }

    private Set<T> createSet() {
        LinkedHashSet values = new LinkedHashSet();
        Collections.addAll(values, this.collection);
        return values;
    }

    private class_6005<T> createWeightedList() {
        class_6005.class_6006 weightedList = class_6005.method_34971();
        for (T value : this.collection) {
            weightedList.method_34975(value, 25);
        }
        return weightedList.method_34974();
    }

    private void assertWeightedListEqual(class_4516 helper, class_6005<T> original, class_6005<T> result) {
        AccessorWeightedRandomList accessOriginal = (AccessorWeightedRandomList)original;
        AccessorWeightedRandomList accessResult = (AccessorWeightedRandomList)result;
        if (accessOriginal.bookshelf$getEntries().size() != accessResult.bookshelf$getEntries().size()) {
            helper.method_35995("List of type " + this.type + " has incorrect size. Original=" + accessOriginal.bookshelf$getEntries().size() + " Result=" + accessResult.bookshelf$getEntries().size());
        } else {
            for (int index = 0; index < accessOriginal.bookshelf$getEntries().size(); ++index) {
                class_6008.class_6010 a = (class_6008.class_6010)accessOriginal.bookshelf$getEntries().get(index);
                class_6008.class_6010 b = (class_6008.class_6010)accessResult.bookshelf$getEntries().get(index);
                if (a.method_34979().method_34976() != b.method_34979().method_34976()) {
                    helper.method_35995("Weighted list of " + this.type + " do not match! index=" + index + " a=" + a.method_34979().method_34976() + " b=" + b.method_34979().method_34976());
                    return;
                }
                if (this.equality.test(a.method_34983(), b.method_34983())) continue;
                helper.method_35995("Weighted list of " + this.type + " do not match! index=" + index + " a=" + a.method_34983() + " b=" + b.method_34983());
                return;
            }
            helper.method_36036();
        }
    }

    private void assertIterableEqual(class_4516 helper, Iterable<T> original, Iterable<T> result) {
        int resultSize;
        int originalSize = Iterables.size(original);
        if (originalSize != (resultSize = Iterables.size(result))) {
            helper.method_35995("List of type " + this.type + " has incorrect size. Original=" + originalSize + " Result=" + resultSize);
        } else {
            for (int index = 0; index < originalSize; ++index) {
                Object b;
                Object a = Iterables.get(original, (int)index);
                if (this.equality.test(a, b = Iterables.get(result, (int)index))) continue;
                helper.method_35995("List of " + this.type + " do not match! index=" + index + " a=" + a + " b=" + b);
                return;
            }
            helper.method_36036();
        }
    }

    @Override
    public String getDefaultBatch() {
        return "bookshelf_serialization_" + this.type;
    }
}

