/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest;

import net.darkhax.bookshelf.api.registry.IRegistryReader;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.minecraft.class_2960;
import net.minecraft.class_4516;
import net.minecraft.class_6302;

public class TestRegistryAccessor<T>
implements ITestable {
    private final IRegistryReader<T> registryReader;
    private final T lastValue;

    public TestRegistryAccessor(IRegistryReader<T> registryReader) {
        this.registryReader = registryReader;
        this.lastValue = registryReader.streamValues().skip(registryReader.streamValues().count() - 1L).findFirst().orElseThrow();
    }

    @class_6302
    public void testRealIdLookup(class_4516 helper) {
        class_2960 id = this.registryReader.getId(this.lastValue);
        if (id != null) {
            helper.method_36036();
        } else {
            helper.method_35995("Id for lookup was null.");
        }
    }

    @class_6302
    public void testNullableLookup(class_4516 helper) {
        T value = this.registryReader.get(new class_2960("fake_mc_fake", "im_not_a_real_boy"));
        if (value != null) {
            helper.method_35995("Expected null. Got " + value);
        } else {
            helper.method_36036();
        }
    }

    @class_6302
    public void testRealValueLookup(class_4516 helper) {
        class_2960 id = this.registryReader.getId(this.lastValue);
        T lookup = this.registryReader.get(id);
        if (id == null) {
            helper.method_35995("Lookup ID was null!");
        } else if (lookup == null) {
            helper.method_35995("Lookup was null for ID " + id + " was null");
        } else if (lookup != this.lastValue) {
            helper.method_35995("Incorrect match. Expected " + this.lastValue + " Got " + lookup);
        } else {
            helper.method_36036();
        }
    }

    @Override
    public String getDefaultBatch() {
        return "bookshelf_serialization_" + this.registryReader.getRegistryName().toString();
    }
}

