/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.inventory.ContainerInventoryAccess;
import net.darkhax.bookshelf.api.inventory.IInventoryAccess;
import net.darkhax.bookshelf.api.inventory.WorldlyContainerInventoryAccess;
import net.darkhax.bookshelf.mixin.inventory.AccessorCraftingContainer;
import net.darkhax.bookshelf.mixin.inventory.AccessorCraftingMenu;
import net.darkhax.bookshelf.mixin.inventory.AccessorInventoryMenu;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3954;

public interface IInventoryHelper {
    @Nullable
    default public class_1703 getCraftingContainer(class_1715 container) {
        class_1703 class_17032;
        if (container instanceof AccessorCraftingContainer) {
            AccessorCraftingContainer accessor = (AccessorCraftingContainer)container;
            class_17032 = accessor.bookshelf$getMenu();
        } else {
            class_17032 = null;
        }
        return class_17032;
    }

    @Nullable
    default public class_1657 getCraftingPlayer(class_1263 container) {
        if (container instanceof class_1661) {
            class_1661 playerInv = (class_1661)container;
            return playerInv.field_7546;
        }
        if (container instanceof class_1715) {
            class_1715 crafting = (class_1715)container;
            class_1703 menu = this.getCraftingContainer(crafting);
            if (menu instanceof AccessorCraftingMenu) {
                AccessorCraftingMenu accessor = (AccessorCraftingMenu)menu;
                return accessor.bookshelf$getPlayer();
            }
            if (menu instanceof AccessorInventoryMenu) {
                AccessorInventoryMenu accessor = (AccessorInventoryMenu)menu;
                return accessor.bookshelf$getOwner();
            }
        }
        return null;
    }

    default public class_1799 damageStack(class_1799 stack, int amount, @Nullable class_1309 owner, @Nullable class_1304 slot) {
        if (stack.method_7963()) {
            if (owner != null) {
                stack.method_7956(amount, owner, e -> {
                    if (slot != null) {
                        e.method_20235(slot);
                    }
                });
            } else if (stack.method_7970(amount, Constants.RANDOM, null)) {
                stack.method_7934(1);
                stack.method_7974(0);
            }
        }
        return stack;
    }

    default public class_2371<class_1799> keepDamageableItems(class_1715 inv, class_2371<class_1799> keptItems, int damageAmount) {
        class_1657 player = this.getCraftingPlayer((class_1263)inv);
        Random random = player != null ? player.method_6051() : Constants.RANDOM;
        for (int i = 0; i < keptItems.size(); ++i) {
            class_1799 stack;
            class_1799 input = inv.method_5438(i).method_7972();
            if (!input.method_7909().method_7846() && (!input.method_7985() || !input.method_7969().method_10577("Unbreaking")) || (stack = this.damageStack(input, damageAmount, (class_1309)player, null)).method_7960()) continue;
            keptItems.set(i, (Object)stack);
        }
        return keptItems;
    }

    default public class_2371<class_1799> toList(class_1263 inventory) {
        class_2371 items = class_2371.method_10213((int)inventory.method_5439(), (Object)class_1799.field_8037);
        this.applyForEach(inventory, (arg_0, arg_1) -> ((class_2371)items).set(arg_0, arg_1));
        return items;
    }

    default public void fill(class_1263 inventory, class_2371<class_1799> fillWith) {
        if (inventory.method_5439() != fillWith.size()) {
            throw new IllegalStateException("Inventory size did not match! inv_size=" + inventory.method_5439() + " fill_size=" + fillWith.size());
        }
        for (int slotId = 0; slotId < fillWith.size(); ++slotId) {
            inventory.method_5447(slotId, (class_1799)fillWith.get(slotId));
        }
    }

    default public void applyForEach(class_1263 inventory, Consumer<class_1799> action) {
        for (int slotId = 0; slotId < inventory.method_5439(); ++slotId) {
            action.accept(inventory.method_5438(slotId));
        }
    }

    default public void applyForEach(class_1263 inventory, BiConsumer<Integer, class_1799> action) {
        for (int slotId = 0; slotId < inventory.method_5439(); ++slotId) {
            action.accept(slotId, inventory.method_5438(slotId));
        }
    }

    default public boolean canItemsStack(class_1799 original, class_1799 toStack) {
        return !toStack.method_7960() && original.method_7962(toStack) && original.method_7985() == toStack.method_7985() && (!original.method_7985() || original.method_7969().equals((Object)toStack.method_7969()));
    }

    @Nullable
    default public IInventoryAccess getInventory(class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        class_2680 state = level.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_3954) {
            class_3954 holder = (class_3954)class_22482;
            class_1278 container = holder.method_17680(state, (class_1936)level, pos);
            if (container != null) {
                return new ContainerInventoryAccess<class_1278>(container);
            }
        } else {
            class_2586 be = level.method_8321(pos);
            if (be instanceof class_1263) {
                class_1263 container = (class_1263)be;
                if (container instanceof class_1278) {
                    class_1278 worldly = (class_1278)container;
                    return new WorldlyContainerInventoryAccess<class_1278>(worldly);
                }
                return new ContainerInventoryAccess<class_1263>(container);
            }
        }
        return null;
    }

    default public void openMenu(class_3222 player, class_3908 provider) {
        this.openMenu(player, provider, buf -> {});
    }

    public void openMenu(class_3222 var1, class_3908 var2, Consumer<class_2540> var3);

    default public class_1799 getCraftingRemainder(class_1799 stack) {
        return this.hasCraftingRemainder(stack) ? new class_1799((class_1935)stack.method_7909().method_7858()) : class_1799.field_8037;
    }

    default public boolean hasCraftingRemainder(class_1799 stack) {
        return stack.method_7909().method_7857();
    }
}

