/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.data.sound;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Objects;
import net.darkhax.bookshelf.api.data.sound.ISound;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class Sound
implements ISound {
    private final class_3414 sound;
    private final class_3419 category;
    private final float pitch;
    private final float volume;

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Sound sound1 = (Sound)other;
        return Float.compare(sound1.pitch, this.pitch) == 0 && Float.compare(sound1.volume, this.volume) == 0 && this.sound.equals(sound1.sound) && this.category == sound1.category;
    }

    public int hashCode() {
        return Objects.hash(this.sound, this.category, Float.valueOf(this.pitch), Float.valueOf(this.volume));
    }

    public Sound(class_3414 sound, class_3419 category, float pitch, float volume) {
        this.sound = sound;
        this.category = category;
        this.pitch = pitch;
        this.volume = volume;
    }

    @Override
    public void playSoundAt(class_1937 level, @Nullable class_1657 originator, double posX, double posY, double posZ) {
        level.method_8465(originator, posX, posY, posZ, this.sound, this.category, this.volume, this.pitch);
    }

    public static class Serializer
    implements ISerializer<Sound> {
        @Override
        public Sound fromJSON(JsonElement json) {
            if (json instanceof JsonObject) {
                JsonObject obj = (JsonObject)json;
                class_3414 sound = Serializers.SOUND_EVENT.fromJSON(obj, "sound");
                class_3419 category = Serializers.SOUND_CATEGORY.fromJSON(obj, "category", class_3419.field_15250);
                float pitch = Serializers.FLOAT.fromJSON(obj, "pitch", Float.valueOf(1.0f)).floatValue();
                float volume = Serializers.FLOAT.fromJSON(obj, "volume", Float.valueOf(1.0f)).floatValue();
                if (pitch < 0.0f || pitch > 1.0f) {
                    throw new JsonParseException("Pitch must be between 0 and 1. Read " + pitch);
                }
                if (volume < 0.0f || volume > 1.0f) {
                    throw new JsonParseException("Volume must be between 0 and 1. Read " + volume);
                }
                return new Sound(sound, category, pitch, volume);
            }
            class_3414 sound = Serializers.SOUND_EVENT.fromJSON(json);
            return new Sound(sound, class_3419.field_15250, 1.0f, 1.0f);
        }

        @Override
        public JsonElement toJSON(Sound toWrite) {
            JsonObject obj = new JsonObject();
            obj.add("sound", Serializers.SOUND_EVENT.toJSON(toWrite.sound));
            obj.add("category", Serializers.SOUND_CATEGORY.toJSON(toWrite.category));
            obj.add("pitch", Serializers.FLOAT.toJSON(Float.valueOf(toWrite.pitch)));
            obj.add("volume", Serializers.FLOAT.toJSON(Float.valueOf(toWrite.volume)));
            return obj;
        }

        @Override
        public Sound fromByteBuf(class_2540 buffer) {
            class_3414 sound = Serializers.SOUND_EVENT.fromByteBuf(buffer);
            class_3419 category = Serializers.SOUND_CATEGORY.fromByteBuf(buffer);
            float pitch = Serializers.FLOAT.fromByteBuf(buffer).floatValue();
            float volume = Serializers.FLOAT.fromByteBuf(buffer).floatValue();
            return new Sound(sound, category, pitch, volume);
        }

        @Override
        public void toByteBuf(class_2540 buffer, Sound toWrite) {
            Serializers.SOUND_EVENT.toByteBuf(buffer, toWrite.sound);
            Serializers.SOUND_CATEGORY.toByteBuf(buffer, toWrite.category);
            Serializers.FLOAT.toByteBuf(buffer, Float.valueOf(toWrite.pitch));
            Serializers.FLOAT.toByteBuf(buffer, Float.valueOf(toWrite.volume));
        }

        @Override
        public class_2520 toNBT(Sound toWrite) {
            class_2487 tag = new class_2487();
            tag.method_10566("sound", Serializers.SOUND_EVENT.toNBT(toWrite.sound));
            tag.method_10566("category", Serializers.SOUND_CATEGORY.toNBT(toWrite.category));
            tag.method_10566("pitch", Serializers.FLOAT.toNBT(Float.valueOf(toWrite.pitch)));
            tag.method_10566("volume", Serializers.FLOAT.toNBT(Float.valueOf(toWrite.volume)));
            return tag;
        }

        @Override
        public Sound fromNBT(class_2520 nbt) {
            if (nbt instanceof class_2487) {
                class_2487 tag = (class_2487)nbt;
                class_3414 sound = Serializers.SOUND_EVENT.fromNBT(tag, "sound");
                class_3419 category = Serializers.SOUND_CATEGORY.fromNBT(tag, "category", class_3419.field_15250);
                float pitch = Serializers.FLOAT.fromNBT(tag, "pitch", Float.valueOf(1.0f)).floatValue();
                float volume = Serializers.FLOAT.fromNBT(tag, "volume", Float.valueOf(1.0f)).floatValue();
                if (pitch < 0.0f || pitch > 1.0f) {
                    throw new NBTParseException("Pitch must be between 0 and 1. Read " + pitch);
                }
                if (volume < 0.0f || volume > 1.0f) {
                    throw new NBTParseException("Volume must be between 0 and 1. Read " + volume);
                }
                return new Sound(sound, category, pitch, volume);
            }
            class_3414 sound = Serializers.SOUND_EVENT.fromNBT(nbt);
            return new Sound(sound, class_3419.field_15250, 1.0f, 1.0f);
        }
    }
}

