/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.util;

import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.darkhax.bookshelf.common.network.AbstractMessage;
import net.darkhax.bookshelf.handler.BookshelfHooks;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.lib.Tuple;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.WordUtils;

public final class Utilities {
    private static String[] vanillaVillagers = new String[]{"farmer", "librarian", "priest", "blacksmith", "butcher"};
    public static String[] vanillaLootChests = new String[]{"dungeonChest", "bonusChest", "villageBlacksmith", "strongholdCrossing", "strongholdLibrary", "strongholdCorridor", "pyramidJungleDispenser", "pyramidJungleChest", "pyramidDesertyChest", "mineshaftCorridor"};
    public static String[] rainbowChars = new String[]{"4", "6", "e", "a", "9", "5"};
    private static List<Enchantment> availableEnchantments;

    public static List<String> wrapStringToList(String string, int lnLength, boolean wrapLongWords, List<String> list) {
        String[] lines = WordUtils.wrap((String)string, (int)lnLength, null, (boolean)wrapLongWords).split(SystemUtils.LINE_SEPARATOR);
        list.addAll(Arrays.asList(lines));
        return list;
    }

    public static List<String> wrapStringToListWithFormat(String string, int lnLength, boolean wrapLongWords, List<String> list, EnumChatFormatting format) {
        String[] lines;
        for (String line : lines = WordUtils.wrap((String)string, (int)lnLength, null, (boolean)wrapLongWords).split(SystemUtils.LINE_SEPARATOR)) {
            list.add(format + line);
        }
        return list;
    }

    public static boolean isFluid(Block block) {
        return block == Blocks.field_150353_l || block == Blocks.field_150355_j || block instanceof IFluidBlock;
    }

    public static Object getThingByName(String name) {
        Object thing = Item.field_150901_e.func_82594_a(name);
        if (thing != null) {
            return thing;
        }
        thing = Block.field_149771_c.func_82594_a(name);
        if (thing != null) {
            return thing;
        }
        return null;
    }

    public static boolean compareClasses(Class class1, Class class2) {
        return class1 != null && class2 != null && class1.getName().equalsIgnoreCase(class2.getName());
    }

    public static boolean compareObjectToClass(Object obj, Class clazz) {
        return Utilities.compareClasses(obj.getClass(), clazz);
    }

    public static String makeUpperCased(String text) {
        return Character.toString(text.charAt(0)).toUpperCase() + text.substring(1);
    }

    public static Class getClassFromString(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isWearingFullSet(EntityLivingBase living, Class armorClass) {
        for (int armorSlot = 1; armorSlot <= 4; ++armorSlot) {
            ItemStack armor = living.func_71124_b(armorSlot);
            if (armor != null && armor.func_77973_b().getClass().equals(armorClass)) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getCustomHorseArmor(EntityHorse horse) {
        return horse.func_70096_w().func_82710_f(23);
    }

    public static void setCustomHorseArmor(EntityHorse horse, ItemStack stack) {
        horse.func_70096_w().func_75692_b(23, (Object)stack);
    }

    public static String getModName(Item item) {
        String itemID = GameData.getItemRegistry().func_148750_c((Object)item);
        return itemID.substring(0, itemID.indexOf(58));
    }

    public static String getModName(Block block) {
        String blockID = GameData.getBlockRegistry().func_148750_c((Object)block);
        return blockID.substring(0, blockID.indexOf(58));
    }

    public static Enchantment getEnchantment(int id) {
        return id >= 0 && id <= Enchantment.field_77331_b.length ? Enchantment.field_77331_b[id] : null;
    }

    public static Potion getPotion(int id) {
        return id >= 0 && id <= Potion.field_76425_a.length ? Potion.field_76425_a[id] : null;
    }

    public static void updateAvailableEnchantments() {
        ArrayList<Enchantment> foundEnchantments = new ArrayList<Enchantment>();
        for (Enchantment enchantment : Enchantment.field_77331_b) {
            if (enchantment == null) continue;
            foundEnchantments.add(enchantment);
        }
        availableEnchantments = foundEnchantments;
    }

    public static List<Enchantment> getAvailableEnchantments() {
        if (availableEnchantments == null) {
            Utilities.updateAvailableEnchantments();
        }
        return availableEnchantments;
    }

    public static <T extends AbstractMessage<T>> void registerMessage(SimpleNetworkWrapper network, Class<T> clazz, int id, Side side) {
        network.registerMessage(clazz, clazz, id, side);
    }

    public static void spawnParticleRing(World world, String name, double x, double y, double z, double velocityX, double velocityY, double velocityZ, double step) {
        for (double degree = 0.0; degree < Math.PI * 2; degree += step) {
            world.func_72869_a(name, x + Math.cos(degree), y, z + Math.sin(degree), velocityX, velocityY, velocityZ);
        }
    }

    public static void spawnParticleRing(World world, String name, float percentage, double x, double y, double z, double velocityX, double velocityY, double velocityZ, double step) {
        for (double degree = 0.0; degree < Math.PI * 2 * (double)percentage; degree += step) {
            world.func_72869_a(name, x + Math.cos(degree), y, z + Math.sin(degree), velocityX, velocityY, velocityZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static String getVillagerName(int id) {
        ResourceLocation skin = VillagerRegistry.getVillagerSkin((int)id, null);
        return id >= 0 && id <= 4 ? vanillaVillagers[id] : (skin != null ? skin.func_110624_b() + "." + skin.func_110623_a().substring(skin.func_110623_a().lastIndexOf("/") + 1, skin.func_110623_a().length() - 4) : "misingno");
    }

    @SideOnly(value=Side.CLIENT)
    public static CreativeTabs getTabFromLabel(String label) {
        for (CreativeTabs tab : CreativeTabs.field_78032_a) {
            if (!tab.func_78013_b().equalsIgnoreCase(label)) continue;
            return tab;
        }
        return null;
    }

    public static void checkDuplicatePotions() {
        if (!BookshelfHooks.conflictingPotions.isEmpty()) {
            Constants.LOG.error(BookshelfHooks.conflictingPotions.size() + " overlapping potions have been detected.");
            for (Tuple tuple : BookshelfHooks.conflictingPotions) {
                String modName = (String)tuple.getFirstObject();
                Potion potion = (Potion)tuple.getSecondObject();
                Constants.LOG.error("The " + potion.func_76393_a() + " effect from " + modName + " is using an overlapping ID. ID: " + potion.field_76415_H);
            }
            int index = 1;
            ArrayList<Integer> unused = new ArrayList<Integer>();
            for (int id = 32; id < Potion.field_76425_a.length; ++id) {
                if (index > BookshelfHooks.conflictingPotions.size() + 5 || Utilities.getPotion(id) != null) continue;
                unused.add(id);
                ++index;
            }
            Constants.LOG.error(unused.isEmpty() || unused.size() < BookshelfHooks.conflictingPotions.size() ? "You have ran out of available potion IDs. This is a serious problem." : "Here are a few recommended potion IDs which are not being used: " + ((Object)unused).toString());
        }
    }
}

