/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.javatuples;

import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.serialization.ObjectDecoderInputStream;
import io.netty.handler.codec.serialization.ObjectEncoderOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.lib.javatuples.Decade;
import net.darkhax.bookshelf.lib.javatuples.Ennead;
import net.darkhax.bookshelf.lib.javatuples.Octet;
import net.darkhax.bookshelf.lib.javatuples.Pair;
import net.darkhax.bookshelf.lib.javatuples.Quartet;
import net.darkhax.bookshelf.lib.javatuples.Quintet;
import net.darkhax.bookshelf.lib.javatuples.Septet;
import net.darkhax.bookshelf.lib.javatuples.Sextet;
import net.darkhax.bookshelf.lib.javatuples.Triplet;
import net.darkhax.bookshelf.lib.javatuples.Unit;
import org.apache.logging.log4j.Level;

public abstract class Tuple
implements Iterable<Object>,
Serializable,
Comparable<Tuple> {
    private static final long serialVersionUID = 5431085632328343101L;
    private final Object[] valueArray;
    private final List<Object> valueList;

    protected Tuple(Object ... values) {
        this.valueArray = values;
        this.valueList = Arrays.asList(values);
    }

    public abstract int getSize();

    public final Object getValue(int pos) {
        if (pos >= this.getSize()) {
            throw new IllegalArgumentException(String.format("Cannot retrieve value index %1$d in %2$s. Indices of %2$s range from 0 to %3$d", pos, this.getClass().getSimpleName(), this.getSize() - 1));
        }
        return this.valueArray[pos];
    }

    @Override
    public final Iterator<Object> iterator() {
        return this.valueList.iterator();
    }

    public final String toString() {
        return this.valueList.toString();
    }

    public final boolean contains(Object value) {
        for (Object val : this.valueList) {
            if (!(val == null ? value == null : val.equals(value))) continue;
            return true;
        }
        return false;
    }

    public final boolean containsAll(Collection<?> collection) {
        for (Object value : collection) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAll(Object ... values) {
        if (values == null) {
            throw new IllegalArgumentException("containsAll needs at least 1 parameter or array cannot be null.");
        }
        for (Object value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public final int indexOf(Object value) {
        int i = 0;
        for (Object val : this.valueList) {
            if (val == null ? value == null : val.equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final int lastIndexOf(Object value) {
        for (int i = this.getSize() - 1; i >= 0; --i) {
            Object val = this.valueList.get(i);
            if (!(val == null ? value == null : val.equals(value))) continue;
            return i;
        }
        return -1;
    }

    public final List<Object> toList() {
        return Collections.unmodifiableList(new ArrayList<Object>(this.valueList));
    }

    public final Object[] toArray() {
        return (Object[])this.valueArray.clone();
    }

    public final int hashCode() {
        return 31 + this.valueList.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return this.valueList.equals(other.valueList);
    }

    @Override
    public int compareTo(Tuple o) {
        int tLen = this.valueArray.length;
        Object[] oValues = o.valueArray;
        int oLen = oValues.length;
        for (int i = 0; i < tLen && i < oLen; ++i) {
            Comparable tElement = (Comparable)this.valueArray[i];
            Comparable oElement = (Comparable)oValues[i];
            int comparison = tElement.compareTo(oElement);
            if (comparison == 0) continue;
            return comparison;
        }
        return Integer.valueOf(tLen).compareTo(oLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tuple readFromByteBufStream(ByteBufInputStream stream) {
        ObjectDecoderInputStream odis = null;
        try {
            odis = new ObjectDecoderInputStream((InputStream)stream);
            Tuple tuple = (Tuple)odis.readObject();
            return tuple;
        }
        catch (IOException ioEx) {
            Constants.LOG.log(Level.ERROR, "Cannot deserialize Tuple!", (Throwable)ioEx);
        }
        catch (ClassNotFoundException cnfEx) {
            Constants.LOG.log(Level.ERROR, "Cannot deserialize Tuple!", (Throwable)cnfEx);
        }
        finally {
            try {
                if (odis != null) {
                    odis.close();
                }
            }
            catch (IOException ex) {
                Constants.LOG.log(Level.ERROR, "Cannot properly close ObjectDecoderInputStream!", (Throwable)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToByteBufStream(Tuple tuple, ByteBufOutputStream stream) {
        ObjectEncoderOutputStream oeos = null;
        try {
            oeos = new ObjectEncoderOutputStream((OutputStream)stream);
            oeos.writeObject((Object)tuple);
        }
        catch (IOException ex) {
            Constants.LOG.log(Level.ERROR, "Cannot serialize Tuple!", (Throwable)ex);
        }
        finally {
            try {
                if (oeos != null) {
                    oeos.close();
                }
            }
            catch (IOException ex) {
                Constants.LOG.log(Level.ERROR, "Cannot properly close ObjectEncoderOutputStream!", (Throwable)ex);
            }
        }
    }

    public static Tuple from(Object ... values) {
        switch (values.length) {
            case 1: {
                return Unit.fromArray(values);
            }
            case 2: {
                return Pair.fromArray(values);
            }
            case 3: {
                return Triplet.fromArray(values);
            }
            case 4: {
                return Quartet.fromArray(values);
            }
            case 5: {
                return Quintet.fromArray(values);
            }
            case 6: {
                return Sextet.fromArray(values);
            }
            case 7: {
                return Septet.fromArray(values);
            }
            case 8: {
                return Octet.fromArray(values);
            }
            case 9: {
                return Ennead.fromArray(values);
            }
            case 10: {
                return Decade.fromArray(values);
            }
        }
        throw new RuntimeException(String.format("Cannot create Tuple with size %d!", values.length));
    }
}

