/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.asm.ASMHelper;
import net.darkhax.bookshelf.buff.BuffEffect;
import net.darkhax.bookshelf.buff.BuffHelper;
import net.darkhax.bookshelf.common.BookshelfRegistry;
import net.darkhax.bookshelf.common.EntityProperties;
import net.darkhax.bookshelf.event.CreativeTabEvent;
import net.darkhax.bookshelf.event.PotionCuredEvent;
import net.darkhax.bookshelf.items.ItemHorseArmor;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.bookshelf.lib.util.SkullUtils;
import net.darkhax.bookshelf.lib.util.Utilities;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ForgeEventHandler {
    @SubscribeEvent
    public void onAnvilUsed(AnvilUpdateEvent event) {
        for (BookshelfRegistry.AnvilRecipe recipe : BookshelfRegistry.getAnvilRecipes()) {
            if (recipe == null || !ItemStackUtils.isValidStack(recipe.output) || !ItemStackUtils.areStacksSimilarWithSize(event.left, recipe.inputLeft) || !ItemStackUtils.areStacksSimilarWithSize(event.right, recipe.inputRight)) continue;
            event.cost = recipe.getExperienceCost(event.left, event.right, event.name);
            event.materialCost = recipe.getMaterialCost(event.left, event.right, event.name);
            if (recipe.nameTaxt != null && !recipe.nameTaxt.isEmpty()) {
                if (recipe.nameTaxt.equalsIgnoreCase(event.name)) {
                    event.output = recipe.getOutput(event.left, event.right, event.name);
                }
                return;
            }
            event.output = recipe.getOutput(event.left, event.right, event.name);
            return;
        }
    }

    @SubscribeEvent
    public void onPotionsCured(PotionCuredEvent event) {
        BuffHelper.cureBuffs(event.entityLiving, event.stack);
    }

    @SubscribeEvent
    public void afterCreativeTabLoaded(CreativeTabEvent.Post event) {
        if (event.tab == CreativeTabs.field_78031_c) {
            for (ItemStack stack : SkullUtils.getMHFSkulls()) {
                event.itemList.add(stack);
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityHorse horse;
        ItemStack customArmor;
        if (!ASMHelper.isASMEnabled) {
            Constants.LOG.warn("The ASM has not been initialized, there is an error with your setup!");
        } else if (event.entity instanceof EntityHorse && (customArmor = Utilities.getCustomHorseArmor(horse = (EntityHorse)event.entity)) != null && customArmor.func_77973_b() instanceof ItemHorseArmor) {
            ItemHorseArmor armor = (ItemHorseArmor)customArmor.func_77973_b();
            armor.onHorseUpdate(horse, customArmor);
        }
        EntityLivingBase entity = event.entityLiving;
        ArrayList<BuffEffect> destroyBuff = new ArrayList<BuffEffect>();
        List<BuffEffect> list = BuffHelper.getEntityEffects(entity);
        for (BuffEffect buff : list) {
            if (buff.getBuff().canUpdate()) {
                buff.getBuff().onBuffTick(entity.field_70170_p, entity, buff.duration, buff.power);
            }
            --buff.duration;
            if (entity.field_70170_p.field_72995_K || buff.duration > 0) continue;
            destroyBuff.add(buff);
        }
        if (!destroyBuff.isEmpty()) {
            for (BuffEffect buff : destroyBuff) {
                buff.getBuff().onEffectEnded();
                EntityProperties.getProperties(entity).remove(buff, false);
            }
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        EntityHorse horse;
        ItemStack customArmor;
        if (!ASMHelper.isASMEnabled) {
            Constants.LOG.warn("The ASM has not been initialized, there is an error with your setup!");
        } else if (event.entity instanceof EntityHorse && (customArmor = Utilities.getCustomHorseArmor(horse = (EntityHorse)event.entity)) != null && customArmor.func_77973_b() instanceof ItemHorseArmor) {
            ItemHorseArmor armor = (ItemHorseArmor)customArmor.func_77973_b();
            event.setCanceled(armor.onHorseDamaged(horse, customArmor, event.source, event.ammount));
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityLivingBase && !EntityProperties.hasProperties((EntityLivingBase)event.entity)) {
            EntityProperties.setProperties((EntityLivingBase)event.entity);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityLivingBase && !event.entity.field_70170_p.field_72995_K && EntityProperties.hasProperties((EntityLivingBase)event.entity)) {
            EntityProperties.getProperties((EntityLivingBase)event.entity).sync(false);
        }
    }
}

