/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.network.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.buff.BuffEffect;
import net.darkhax.bookshelf.common.EntityProperties;
import net.darkhax.bookshelf.common.network.AbstractMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PacketSyncPlayerProperties
extends AbstractMessage<PacketSyncPlayerProperties> {
    private List<BuffEffect> buffs = new ArrayList<BuffEffect>();
    private int entityId;

    public PacketSyncPlayerProperties() {
    }

    public PacketSyncPlayerProperties(EntityProperties props) {
        this.buffs = props.getBuffs();
        this.entityId = props.entity.func_145782_y();
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        int size = buf.readInt();
        this.buffs = new ArrayList<BuffEffect>();
        for (int i = 0; i < size; ++i) {
            this.buffs.add(BuffEffect.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf)));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.buffs.size());
        for (BuffEffect buff : this.buffs) {
            NBTTagCompound compound = new NBTTagCompound();
            buff.writeToNBT(compound);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound);
        }
    }

    @Override
    public void handleClientMessage(PacketSyncPlayerProperties message, EntityPlayer player) {
        Entity entity;
        if (player != null && player.field_70170_p != null && (entity = player.field_70170_p.func_73045_a(message.entityId)) != null && entity instanceof EntityLivingBase) {
            EntityProperties.getProperties((EntityLivingBase)entity).setBuffs(message.buffs);
        }
    }

    @Override
    public void handleServerMessage(PacketSyncPlayerProperties message, EntityPlayer player) {
    }
}

