/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.common.BookshelfRegistry;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

@SideOnly(value=Side.CLIENT)
public class DescriptionHandler
implements IUsageHandler,
ICraftingHandler {
    private static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    private ItemStack displayStack;
    private int textColor = 0x555555;
    private int displayWidth = 166;
    private String[] pages;

    public DescriptionHandler(ItemStack stack) {
        if (BookshelfRegistry.doesStackHaveDescription(stack)) {
            ArrayList<String> pageList = new ArrayList<String>();
            for (String descriptionKey : BookshelfRegistry.getDescriptionKeys(stack)) {
                pageList.addAll(this.createPages(StatCollector.func_74838_a((String)descriptionKey)));
            }
            if (!pageList.isEmpty()) {
                this.pages = pageList.toArray(new String[pageList.size()]);
            }
            this.displayStack = stack.func_77946_l();
            this.displayStack.field_77994_a = 1;
        }
    }

    private List<String> createPages(String description) {
        ArrayList<String> list = new ArrayList<String>();
        List lines = fontRenderer.func_78271_c(description, this.displayWidth - 7);
        if (lines.size() < 10) {
            list.add(description);
        } else {
            String pageText = "";
            for (int lineIndex = 0; lineIndex < lines.size(); ++lineIndex) {
                pageText = pageText + lines.get(lineIndex) + " ";
                if (lineIndex <= 0 || lineIndex % 10 != 0) continue;
                list.add(pageText.trim());
                pageText = "";
            }
            if (!(pageText = pageText.trim()).isEmpty()) {
                list.add(pageText);
            }
        }
        return list;
    }

    public void drawBackground(int recipe) {
    }

    public void drawForeground(int recipe) {
        List description = fontRenderer.func_78271_c(StatCollector.func_74838_a((String)this.pages[recipe]), this.displayWidth - 7);
        int lineNumber = 0;
        for (String line : description) {
            GuiDraw.drawString((String)line, (int)(this.displayWidth / 2 - GuiDraw.getStringWidth((String)line) / 2), (int)(18 + lineNumber * 8), (int)this.textColor, (boolean)false);
            ++lineNumber;
        }
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        return new ArrayList<PositionedStack>();
    }

    public List<PositionedStack> getOtherStacks(int recipe) {
        return new ArrayList<PositionedStack>();
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return null;
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        return null;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"gui.bookshelf.nei.documentation");
    }

    public PositionedStack getResultStack(int recipe) {
        return new PositionedStack((Object)this.displayStack, this.displayWidth / 2 - 9, 0, false);
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> tooltip, int recipe) {
        return tooltip;
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> tooltip, int recipe) {
        return tooltip;
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public boolean keyTyped(GuiRecipe gui, char key, int code, int recipe) {
        return false;
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        return false;
    }

    public int numRecipes() {
        return ItemStackUtils.isValidStack(this.displayStack) && this.pages != null ? this.pages.length : 0;
    }

    public void onUpdate() {
    }

    public int recipiesPerPage() {
        return 1;
    }

    public IUsageHandler getUsageHandler(String inputID, Object ... ingredients) {
        if (!inputID.equals("item")) {
            return this;
        }
        for (Object ingredient : ingredients) {
            if (!(ingredient instanceof ItemStack) || !ItemStackUtils.isValidStack((ItemStack)ingredient) || !BookshelfRegistry.doesStackHaveDescription((ItemStack)ingredient)) continue;
            return new DescriptionHandler((ItemStack)ingredient);
        }
        return this;
    }

    public ICraftingHandler getRecipeHandler(String outputID, Object ... results) {
        if (!outputID.equals("item")) {
            return this;
        }
        for (Object result : results) {
            if (!(result instanceof ItemStack) || !ItemStackUtils.isValidStack((ItemStack)result) || !BookshelfRegistry.doesStackHaveDescription((ItemStack)result)) continue;
            return new DescriptionHandler((ItemStack)result);
        }
        return this;
    }
}

