/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.buff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.darkhax.bookshelf.buff.Buff;
import net.darkhax.bookshelf.buff.BuffEffect;
import net.darkhax.bookshelf.common.EntityProperties;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class BuffHelper {
    public static List<BuffEffect> getEntityEffects(EntityLivingBase entity) {
        return EntityProperties.getProperties(entity).getBuffs();
    }

    public static BuffEffect getEntityBuffEffect(EntityLivingBase entity, Buff buff) {
        for (BuffEffect effect : BuffHelper.getEntityEffects(entity)) {
            if (!effect.getBuff().equals(buff)) continue;
            return effect;
        }
        return null;
    }

    public static boolean addBuff(World world, EntityLivingBase entity, BuffEffect effect) {
        if (entity != null && !world.field_72995_K) {
            if (BuffHelper.hasBuff(entity, effect.getBuff())) {
                EntityProperties.getProperties(entity).remove(effect, false);
            }
            EntityProperties.getProperties(entity).add(effect, false);
            return true;
        }
        return false;
    }

    public static boolean hasBuff(EntityLivingBase entity, Buff buff) {
        for (BuffEffect effect : BuffHelper.getEntityEffects(entity)) {
            if (!effect.getBuff().equals(buff)) continue;
            return true;
        }
        return false;
    }

    public static void cureBuffs(EntityLivingBase entity, ItemStack stack) {
        if (!entity.field_70170_p.field_72995_K) {
            List<BuffEffect> list = BuffHelper.getEntityEffects(entity);
            Iterator<BuffEffect> iterator = list.iterator();
            while (iterator.hasNext()) {
                BuffEffect effect = iterator.next();
                if (!effect.getBuff().shouldBeCured(entity, stack)) continue;
                iterator.remove();
            }
            EntityProperties.getProperties(entity).setBuffs(list).sync(true);
        }
    }

    public static NBTTagList writeNBT(List<BuffEffect> buffs) {
        NBTTagList nbtList = new NBTTagList();
        for (BuffEffect effect : buffs) {
            NBTTagCompound buffNBT = new NBTTagCompound();
            effect.writeToNBT(buffNBT);
            nbtList.func_74742_a((NBTBase)buffNBT);
        }
        return nbtList;
    }

    public static List<BuffEffect> readNBT(NBTTagList list) {
        ArrayList<BuffEffect> effects = new ArrayList<BuffEffect>();
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                BuffEffect buff = BuffEffect.readFromNBT(tag);
                effects.add(buff);
            }
        }
        return effects;
    }
}

