/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.asm.transformers;

import net.darkhax.bookshelf.asm.ASMConfigs;
import net.darkhax.bookshelf.asm.ASMHelper;
import net.darkhax.bookshelf.asm.Mappings;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PotionTransformer {
    public static byte[] transform(String name, String transformedName, byte[] bytes) {
        if (ASMConfigs.potionDetectionEnabled) {
            ClassNode potionClass = ASMHelper.createClassFromByteArray(bytes);
            PotionTransformer.transformConstructor(ASMHelper.getMethodFromClass(potionClass, "<init>", "(IZI)V"));
            return ASMHelper.createByteArrayFromClass(potionClass, 1);
        }
        return bytes;
    }

    private static void transformConstructor(MethodNode method) {
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
        needle.add((AbstractInsnNode)new VarInsnNode(21, 1));
        needle.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/potion/Potion", Mappings.potionID, "I"));
        InsnList instructions = new InsnList();
        LabelNode start = new LabelNode();
        LabelNode end = new LabelNode();
        instructions.add((AbstractInsnNode)start);
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, "net/darkhax/bookshelf/handler/BookshelfHooks", "onPotionConstructed", "(Lnet/minecraft/potion/Potion;)V", false));
        instructions.add((AbstractInsnNode)end);
        AbstractInsnNode pointer = ASMHelper.findLastNodeFromNeedle(method.instructions, needle);
        method.instructions.insert(pointer, instructions);
    }
}

