/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.asm.transformers;

import net.darkhax.bookshelf.asm.ASMHelper;
import net.darkhax.bookshelf.asm.Mappings;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ItemColorTransformer {
    public static byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassNode itemClass = ASMHelper.createClassFromByteArray(bytes);
        if (ASMHelper.hasClassMethodName(itemClass, Mappings.getColorFromItemStack)) {
            ItemColorTransformer.transformGetColorFromItemStack(ASMHelper.getMethodFromClass(itemClass, Mappings.getColorFromItemStack, "(Lnet/minecraft/item/ItemStack;I)I"));
        }
        return ASMHelper.createByteArrayFromClass(itemClass, 1);
    }

    private static void transformGetColorFromItemStack(MethodNode method) {
        InsnList insns = new InsnList();
        LabelNode l0 = new LabelNode();
        insns.add((AbstractInsnNode)l0);
        insns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", Mappings.hasTagCompound, "()Z", false));
        LabelNode l1 = new LabelNode();
        insns.add((AbstractInsnNode)new JumpInsnNode(153, l1));
        insns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", Mappings.getTagCompound, "()Lnet/minecraft/nbt/NBTTagCompound;", false));
        insns.add((AbstractInsnNode)new LdcInsnNode((Object)"bookshelfColor"));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/nbt/NBTTagCompound", Mappings.hasKey, "(Ljava/lang/String;)Z", false));
        insns.add((AbstractInsnNode)new JumpInsnNode(153, l1));
        LabelNode l2 = new LabelNode();
        insns.add((AbstractInsnNode)l2);
        insns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/item/ItemStack", Mappings.getTagCompound, "()Lnet/minecraft/nbt/NBTTagCompound;", false));
        insns.add((AbstractInsnNode)new LdcInsnNode((Object)"bookshelfColor"));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/nbt/NBTTagCompound", Mappings.getInteger, "(Ljava/lang/String;)I", false));
        insns.add((AbstractInsnNode)new InsnNode(172));
        insns.add((AbstractInsnNode)l1);
        method.instructions.insert(method.instructions.get(0), insns);
    }
}

