/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.asm.transformers;

import net.darkhax.bookshelf.asm.ASMHelper;
import net.darkhax.bookshelf.asm.Mappings;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CreativeTabsTransformer {
    public static byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassNode creativeTabsClass = ASMHelper.createClassFromByteArray(bytes);
        if (ASMHelper.hasClassMethodName(creativeTabsClass, Mappings.displayAllReleventItems)) {
            CreativeTabsTransformer.transformDisplayAllReleventItems(ASMHelper.getMethodFromClass(creativeTabsClass, Mappings.displayAllReleventItems, "(Ljava/util/List;)V"));
            return ASMHelper.createByteArrayFromClass(creativeTabsClass, 1);
        }
        return bytes;
    }

    private static void transformDisplayAllReleventItems(MethodNode method) {
        InsnList preInsns = new InsnList();
        LabelNode preStart = new LabelNode();
        preInsns.add((AbstractInsnNode)preStart);
        preInsns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        preInsns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        preInsns.add((AbstractInsnNode)new MethodInsnNode(184, "net/darkhax/bookshelf/handler/BookshelfHooks", "onCreativeTabDisplayPre", "(Lnet/minecraft/creativetab/CreativeTabs;Ljava/util/List;)Z", false));
        LabelNode l1 = new LabelNode();
        preInsns.add((AbstractInsnNode)new JumpInsnNode(153, l1));
        LabelNode l2 = new LabelNode();
        preInsns.add((AbstractInsnNode)l2);
        preInsns.add((AbstractInsnNode)new InsnNode(177));
        preInsns.add((AbstractInsnNode)l1);
        preInsns.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        method.instructions.insertBefore(method.instructions.getFirst(), preInsns);
        InsnList postNeedle = new InsnList();
        LabelNode l14 = new LabelNode();
        postNeedle.add((AbstractInsnNode)new VarInsnNode(25, 0));
        postNeedle.add((AbstractInsnNode)new VarInsnNode(25, 1));
        postNeedle.add((AbstractInsnNode)new VarInsnNode(25, 0));
        postNeedle.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/creativetab/CreativeTabs", Mappings.getRelevantEnchantmentTypes, "()[Lnet/minecraft/enchantment/EnumEnchantmentType;", false));
        postNeedle.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/creativetab/CreativeTabs", Mappings.addEnchantmentBooksToList, "(Ljava/util/List;[Lnet/minecraft/enchantment/EnumEnchantmentType;)V", false));
        postNeedle.add((AbstractInsnNode)l14);
        InsnList postInsns = new InsnList();
        LabelNode post = new LabelNode();
        postInsns.add((AbstractInsnNode)post);
        postInsns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        postInsns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        postInsns.add((AbstractInsnNode)new MethodInsnNode(184, "net/darkhax/bookshelf/handler/BookshelfHooks", "onCreativeTabDisplayPost", "(Lnet/minecraft/creativetab/CreativeTabs;Ljava/util/List;)V", false));
        AbstractInsnNode pointer = ASMHelper.findLastNodeFromNeedle(method.instructions, postNeedle);
        method.instructions.insert(pointer, postInsns);
    }
}

