/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.asm.transformers;

import net.darkhax.bookshelf.asm.ASMHelper;
import net.darkhax.bookshelf.asm.Mappings;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ContainerEnchantmentTransformer {
    public static byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassNode itemStackClass = ASMHelper.createClassFromByteArray(bytes);
        ContainerEnchantmentTransformer.transformEnchantItem(ASMHelper.getMethodFromClass(itemStackClass, Mappings.enchantItem, "(Lnet/minecraft/entity/player/EntityPlayer;I)Z"));
        return ASMHelper.createByteArrayFromClass(itemStackClass, 1);
    }

    private static void transformEnchantItem(MethodNode method) {
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
        needle.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/inventory/ContainerEnchantment", Mappings.rand, "Ljava/util/Random;"));
        needle.add((AbstractInsnNode)new VarInsnNode(25, 3));
        needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
        needle.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/inventory/ContainerEnchantment", Mappings.enchantLevels, "[I"));
        needle.add((AbstractInsnNode)new VarInsnNode(21, 2));
        needle.add((AbstractInsnNode)new InsnNode(46));
        needle.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/enchantment/EnchantmentHelper", Mappings.buildEnchantmentList, "(Ljava/util/Random;Lnet/minecraft/item/ItemStack;I)Ljava/util/List;", false));
        needle.add((AbstractInsnNode)new VarInsnNode(58, 4));
        InsnList newInsns = new InsnList();
        LabelNode start = new LabelNode();
        LabelNode exit = new LabelNode();
        newInsns.add((AbstractInsnNode)start);
        newInsns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        newInsns.add((AbstractInsnNode)new VarInsnNode(25, 3));
        newInsns.add((AbstractInsnNode)new VarInsnNode(21, 2));
        newInsns.add((AbstractInsnNode)new VarInsnNode(25, 4));
        newInsns.add((AbstractInsnNode)new MethodInsnNode(184, "net/darkhax/bookshelf/handler/BookshelfHooks", "onItemEnchanted", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;ILjava/util/List;)Ljava/util/List;", false));
        newInsns.add((AbstractInsnNode)new VarInsnNode(58, 4));
        newInsns.add((AbstractInsnNode)exit);
        AbstractInsnNode pointer = ASMHelper.findLastNodeFromNeedle(method.instructions, needle);
        if (pointer != null) {
            method.instructions.insert(pointer, newInsns);
        }
    }
}

