/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class WeightedSelector<T> {
    private static final Random RANDOM = new Random();
    private final List<WeightedEntry<T>> entries = new ArrayList<WeightedEntry<T>>();
    private int total = 0;

    public boolean addEntry(T value, int weight) {
        return this.addEntry(new WeightedEntry<T>(value, weight));
    }

    public boolean addEntry(WeightedEntry<T> entry) {
        boolean added = this.entries.add(entry);
        if (added) {
            this.total += entry.getWeight();
        }
        return added;
    }

    public boolean removeEntry(WeightedEntry<T> entry) {
        boolean removed = this.entries.remove(entry);
        if (removed) {
            this.total -= entry.getWeight();
        }
        return removed;
    }

    public List<WeightedEntry<T>> getEntries() {
        return this.entries;
    }

    public WeightedEntry<T> getRandomEntry() {
        int selected = RANDOM.nextInt(this.total);
        int current = 0;
        for (WeightedEntry<T> entry : this.entries) {
            if (selected >= (current += ((WeightedEntry)entry).weight)) continue;
            return entry;
        }
        return null;
    }

    public int updateTotal() {
        int total = 0;
        for (WeightedEntry<T> entry : this.entries) {
            total += entry.getWeight();
        }
        return total;
    }

    public static class WeightedEntry<T> {
        private final T entry;
        private final int weight;

        public WeightedEntry(T entry, int weight) {
            this.entry = entry;
            this.weight = weight;
        }

        public T getEntry() {
            return this.entry;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

