/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.Calendar;

public final class NumericUtils {
    public static final int[] NUMERIC_KEYS = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 71, 72, 73, 75, 76, 77, 79, 80, 81};

    private NumericUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean isKeyCodeNumeric(int keyCode) {
        for (int validKey : NUMERIC_KEYS) {
            if (validKey != keyCode) continue;
            return true;
        }
        return false;
    }

    public static boolean isChristmasTime() {
        return NumericUtils.isSpecialDay(12, 24, 26);
    }

    public static boolean isHalloweenTime() {
        return NumericUtils.isSpecialDay(10, 25, 31);
    }

    public static boolean isSpecialDay(int month, int day) {
        return NumericUtils.isSpecialDay(month, day, day);
    }

    public static boolean isSpecialDay(int month, int start, int end) {
        Calendar today = Calendar.getInstance();
        return today.get(2) + 1 == month && today.get(5) >= start && today.get(5) <= end;
    }
}

