/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModUtils {
    private ModUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static String getModName(IForgeRegistryEntry.Impl<?> registerable) {
        String modID = registerable.getRegistryName().func_110624_b();
        ModContainer mod = ModUtils.getModContainer(modID);
        return mod != null ? mod.getName() : ("minecraft".equals(modID) ? "Minecraft" : "Unknown");
    }

    public static String getModName(Entity entity) {
        if (entity == null) {
            return "Unknown";
        }
        EntityRegistry.EntityRegistration reg = EntityRegistry.instance().lookupModSpawn(entity.getClass(), false);
        if (reg != null) {
            ModContainer mod = reg.getContainer();
            if (mod != null) {
                return mod.getName();
            }
            return "Unknown";
        }
        return "Minecraft";
    }

    public static ModContainer getModContainer(String modID) {
        return (ModContainer)Loader.instance().getIndexedModList().get(modID);
    }

    public static String getModName(String modId) {
        ModContainer mod = ModUtils.getModContainer(modId);
        return mod != null ? mod.getName() : modId;
    }

    @SideOnly(value=Side.CLIENT)
    public static CreativeTabs getTabFromLabel(String label) {
        for (CreativeTabs tab : CreativeTabs.field_78032_a) {
            if (!tab.func_78013_b().equalsIgnoreCase(label)) continue;
            return tab;
        }
        return null;
    }
}

