/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingHelper {
    private final Logger logger;

    public LoggingHelper(String name) {
        this(LogManager.getLogger((String)name));
    }

    public LoggingHelper(Logger logger) {
        this.logger = logger;
    }

    public void catching(Throwable t) {
        this.logger.catching(t);
    }

    public void debug(String message, Object ... params) {
        this.logger.debug(message, params);
    }

    public void error(String message, Object ... params) {
        this.logger.error(message, params);
    }

    public void fatal(String message, Object ... params) {
        this.logger.fatal(message, params);
    }

    public void info(String message, Object ... params) {
        this.logger.info(message, params);
    }

    public void log(Level level, String message, Object ... params) {
        this.logger.log(level, message, params);
    }

    public void trace(String message, Object ... params) {
        this.logger.trace(message, params);
    }

    public void warn(String message, Object ... params) {
        this.warn(new LogWarningException(), message, params);
    }

    public void warn(Throwable t, String message, Object ... params) {
        this.logger.warn(message, params);
        this.logger.catching(t);
    }

    public Logger getLogger() {
        return this.logger;
    }

    private static class LogWarningException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public LogWarningException() {
            super("An error was encountered. This is how!");
        }
    }
}

