/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting;

import net.darkhax.bookshelf.crafting.IAnvilRecipe;
import net.darkhax.bookshelf.util.StackUtils;
import net.minecraft.item.ItemStack;

public class AnvilRecipe
implements IAnvilRecipe {
    private final ItemStack requiredLeft;
    private final ItemStack requiredRight;
    private final String requiredName;
    private final int experienceCost;
    private final int materialCost;
    private final ItemStack output;

    public AnvilRecipe(ItemStack firstInput, ItemStack secondInput, int experience, ItemStack outputStack) {
        this(firstInput, secondInput, null, experience, 0, outputStack);
    }

    public AnvilRecipe(ItemStack firstInput, ItemStack secondInput, String requiredName, int experience, int materialCost, ItemStack outputStack) {
        this.requiredLeft = firstInput;
        this.requiredRight = secondInput;
        this.requiredName = requiredName;
        this.experienceCost = experience;
        this.materialCost = materialCost;
        this.output = outputStack;
    }

    @Override
    public boolean isValidRecipe(ItemStack leftSlot, ItemStack rightSlot, String name) {
        return StackUtils.areStacksSimilarWithSize(leftSlot, this.requiredLeft) && StackUtils.areStacksSimilarWithSize(rightSlot, this.requiredRight) && this.requiredName != null && !this.requiredName.isEmpty() ? this.requiredName.equals(name) : true;
    }

    @Override
    public int getExperienceCost(ItemStack leftSlot, ItemStack rightSlot, String name) {
        return this.experienceCost;
    }

    @Override
    public int getMaterialCost(ItemStack leftSlot, ItemStack rightSlot, String name) {
        return this.materialCost;
    }

    @Override
    public ItemStack getOutput(ItemStack leftSlot, ItemStack rightSlot, String name) {
        return this.output.func_77946_l();
    }
}

