/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.math.kmeans;

import java.util.LinkedList;
import java.util.List;
import net.mehvahdjukaar.selene.math.kmeans.DataSet;
import net.mehvahdjukaar.selene.math.kmeans.IDataEntry;

public class KMeans {
    static final Double PRECISION = 0.01;

    public static <A> LinkedList<IDataEntry<A>> kMeansPP(DataSet<A> data, int K) {
        LinkedList<IDataEntry<A>> centroids = new LinkedList<IDataEntry<A>>();
        centroids.add(data.randomFromDataSet());
        for (int i = 1; i < K; ++i) {
            centroids.add(data.calculateWeighedCentroid());
        }
        return centroids;
    }

    public static <A> void kMeans(DataSet<A> data, int K) {
        List<IDataEntry<A>> centroids = KMeans.kMeansPP(data, K);
        Double SSE = Double.MAX_VALUE;
        while (true) {
            List<IDataEntry<A>> points = data.getColorPoints();
            for (IDataEntry<A> point : points) {
                float minDist = Float.MAX_VALUE;
                for (int i = 0; i < centroids.size(); ++i) {
                    float dist = centroids.get(i).distTo(point);
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    point.setClusterNo(i);
                }
            }
            centroids = data.recomputeCentroids(K);
            Double newSSE = data.calculateTotalSSE(centroids);
            if (SSE - newSSE <= PRECISION) break;
            SSE = newSSE;
        }
    }
}

