/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.math.colors;

import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import net.mehvahdjukaar.selene.math.colors.BaseColor;
import net.mehvahdjukaar.selene.math.colors.ColorSpaces;
import net.mehvahdjukaar.selene.math.colors.RGBColor;

@Immutable
public class HCLColor
extends BaseColor<HCLColor> {
    public HCLColor(float h, float c, float l, float a) {
        super(h, c, l, a);
    }

    public String toString() {
        return String.format("H: %s, C: %s, L %s", (int)(255.0f * this.hue()), (int)(255.0f * this.chroma()), (int)(255.0f * this.luminance()));
    }

    public float hue() {
        return this.v0;
    }

    public float chroma() {
        return this.v1;
    }

    public float luminance() {
        return this.v2;
    }

    public float alpha() {
        return this.v3;
    }

    public HCLColor withHue(float hue) {
        return new HCLColor(hue, this.chroma(), this.luminance(), this.alpha());
    }

    public HCLColor withChroma(float chroma) {
        return new HCLColor(this.hue(), chroma, this.luminance(), this.alpha());
    }

    public HCLColor withLuminance(float luminance) {
        return new HCLColor(this.hue(), this.chroma(), luminance, this.alpha());
    }

    public HCLColor withAlpha(float alpha) {
        return new HCLColor(this.hue(), this.chroma(), this.luminance(), alpha);
    }

    @Override
    public RGBColor asRGB() {
        return ColorSpaces.HCLtoLAB(this).asRGB();
    }

    @Override
    public HCLColor asHCL() {
        return this;
    }

    public static HCLColor averageColors(HCLColor ... colors) {
        float size = colors.length;
        Stream<Float> list = Arrays.stream(colors).map(HCLColor::hue);
        Float[] hues = (Float[])list.toArray(Float[]::new);
        float cr = 0.0f;
        float l = 0.0f;
        float a = 0.0f;
        for (HCLColor c : colors) {
            cr += c.chroma();
            l += c.luminance();
            a += c.alpha();
        }
        return new HCLColor(HCLColor.averageAngles(hues), cr / size, l / size, a / size);
    }

    @Override
    public HCLColor mixWith(HCLColor color, float bias) {
        float h;
        float i = 1.0f - bias;
        for (h = HCLColor.weightedAverageAngles(this.hue(), color.hue(), bias); h < 0.0f; h += 1.0f) {
        }
        float c = this.chroma() * i + color.chroma() * bias;
        float b = this.luminance() * i + color.luminance() * bias;
        float a = this.alpha() * i + color.alpha() * bias;
        return new HCLColor(h, c, b, a);
    }

    @Override
    public HCLColor fromRGB(RGBColor rgb) {
        return rgb.asHCL();
    }

    @Override
    public float distTo(HCLColor other) {
        float h = this.hue();
        float h2 = other.hue();
        float c = this.chroma();
        float c2 = other.chroma();
        double x = (double)c * Math.cos((double)h * Math.PI * 2.0) - (double)c2 * Math.cos((double)h2 * Math.PI * 2.0);
        double y = (double)c * Math.sin((double)h * Math.PI * 2.0) - (double)c2 * Math.sin((double)h2 * Math.PI * 2.0);
        return (float)Math.sqrt(x * x + y * y + (double)((this.luminance() - other.luminance()) * (this.luminance() - other.luminance())));
    }
}

