/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class WoodSetType {
    public final ResourceLocation id;
    public final Material material;
    public final Block plankBlock;
    public final String shortenedNamespace;
    @Nullable
    public final Block logBlock;
    @Nullable
    public final Item signItem;

    protected WoodSetType(ResourceLocation id, Block baseBlock) {
        this.id = id;
        this.plankBlock = baseBlock;
        this.material = baseBlock.m_49966_().m_60767_();
        this.shortenedNamespace = id.m_135827_().equals("minecraft") ? "" : "_" + WoodSetType.abbreviateString(id.m_135827_());
        ResourceLocation[] test = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), id.m_135815_() + "_log"), new ResourceLocation(id.m_135827_(), "log_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_log"), new ResourceLocation("log_" + id.m_135815_()), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_stem"), new ResourceLocation(id.m_135827_(), "stem_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_stem"), new ResourceLocation("stem_" + id.m_135815_())};
        Block temp = null;
        for (ResourceLocation r : test) {
            if (!ForgeRegistries.BLOCKS.containsKey(r)) continue;
            temp = (Block)ForgeRegistries.BLOCKS.getValue(r);
            break;
        }
        this.logBlock = temp;
        ResourceLocation[] test2 = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), id.m_135815_() + "_sign"), new ResourceLocation(id.m_135827_(), "sign_" + id.m_135815_())};
        Item temp2 = null;
        for (ResourceLocation r : test2) {
            if (!ForgeRegistries.ITEMS.containsKey(r)) continue;
            temp2 = (Item)ForgeRegistries.ITEMS.getValue(r);
            break;
        }
        this.signItem = temp2;
    }

    public String toString() {
        return this.id.toString();
    }

    public String getWoodName() {
        return this.id.m_135815_();
    }

    public String getNamespace() {
        return this.id.m_135827_();
    }

    public String getNameForTranslation(String append) {
        return Arrays.stream((this.getWoodName() + "_" + append).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    @Deprecated
    public String getAppendableId() {
        return this.getWoodName() + this.shortenedNamespace;
    }

    public String getVariantId(String baseName) {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return baseName + "_" + this.getWoodName();
        }
        return this.getNamespace() + "/" + baseName + "_" + this.getWoodName();
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getWoodName();
        }
        return this.getNamespace() + "/" + this.getWoodName();
    }

    public boolean shouldHaveBlockSet() {
        return this.logBlock != null;
    }

    public boolean canBurn() {
        return this.material.m_76335_();
    }

    public MaterialColor getColor() {
        return this.material.m_76339_();
    }

    public boolean isVanilla() {
        return this.getNamespace().equals("minecraft");
    }

    private static String abbreviateString(String string) {
        if (string.length() <= 5) {
            return string;
        }
        String[] a = string.split("_");
        if (a.length > 2) {
            return "" + a[0].charAt(0) + a[1].charAt(0) + a[2].charAt(0) + (Serializable)(a.length > 3 ? Character.valueOf(a[3].charAt(0)) : "");
        }
        if (a.length > 1) {
            return a[0].substring(0, Math.min(2, a[0].length())) + a[1].substring(0, Math.min(2, a[0].length()));
        }
        return string.substring(0, 4);
    }
}

