/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Locale;
import net.mehvahdjukaar.selene.data.BlockLootTableAccessor;
import net.mehvahdjukaar.selene.resourcepack.DynamicResourcePack;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.event.server.ServerStartedEvent;

public class DynamicDataPack
extends DynamicResourcePack {
    public DynamicDataPack(ResourceLocation name) {
        super(name, PackType.SERVER_DATA);
    }

    public void register(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        PackRepository packs = server.m_129891_();
        this.addPackToRepository(packs);
        try {
            server.m_129861_(packs.m_10523_()).get();
        }
        catch (Exception e) {
            LOGGER.error("Failed to reload dynamic resource pack {}.", (Object)this.m_8017_(), (Object)e);
        }
    }

    public void addTag(ResourceLocation tagLocation, Collection<ResourceLocation> values, TagType ... types) {
        JsonObject json = new JsonObject();
        json.addProperty("replace", Boolean.valueOf(false));
        JsonArray array = new JsonArray();
        values.forEach(v -> array.add(v.toString()));
        json.add("values", (JsonElement)array);
        for (TagType type : types) {
            this.addJson(new ResourceLocation(tagLocation.m_135827_(), type.name().toLowerCase(Locale.ROOT) + "/" + tagLocation.m_135815_()), (JsonElement)json, RPUtils.ResType.TAGS);
        }
    }

    public void addLootTable(ResourceLocation lootTableLocation, JsonElement lootTable) {
        this.addJson(lootTableLocation, lootTable, RPUtils.ResType.LOOT_TABLES);
    }

    public void addSimpleBlockLootTable(Block block) {
        this.addJson(block.m_60589_(), LootTables.m_79200_((LootTable)BlockLootTableAccessor.dropping((ItemLike)block).m_79165_(LootContextParamSets.f_81421_).m_79167_()), RPUtils.ResType.LOOT_TABLES);
    }

    public void addRecipe(FinishedRecipe recipe) {
        this.addJson(recipe.m_6445_(), (JsonElement)recipe.m_125966_(), RPUtils.ResType.RECIPES);
    }

    public void addRecipeWithAdvancement(FinishedRecipe recipe) {
        this.addRecipe(recipe);
        ResourceLocation advancementId = recipe.m_6448_();
        if (advancementId != null) {
            this.addJson(advancementId, (JsonElement)recipe.m_5860_(), RPUtils.ResType.ADVANCEMENTS);
        }
    }

    public static enum TagType {
        BLOCKS,
        ITEMS,
        ENTITY_TYPES;

    }
}

