/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.selene.fluids.ISoftFluidHolder;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class DispenserHelper {
    private static Set<Item> REGISTERED_FLUID_ITEMS = new HashSet<Item>();
    public static final DefaultDispenseItemBehavior PLACE_BLOCK_BEHAVIOR = new PlaceBlockDispenseBehavior();
    private static final DefaultDispenseItemBehavior SHOOT_BEHAVIOR = new DefaultDispenseItemBehavior();
    public static final DefaultDispenseItemBehavior SPAWN_EGG_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            EntityType type = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
            type.m_20592_(source.m_7727_(), stack, null, source.m_7961_().m_142300_(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
            stack.m_41774_(1);
            return stack;
        }
    };

    public static void registerCustomBehavior(AdditionalDispenserBehavior behavior) {
        DispenserBlock.m_52672_((ItemLike)behavior.item, (DispenseItemBehavior)behavior);
    }

    public static void registerSpawnEggBehavior(ItemLike egg) {
        DispenserBlock.m_52672_((ItemLike)egg, (DispenseItemBehavior)SPAWN_EGG_BEHAVIOR);
    }

    public static void registerPlaceBlockBehavior(ItemLike block) {
        DispenserBlock.m_52672_((ItemLike)block, (DispenseItemBehavior)PLACE_BLOCK_BEHAVIOR);
    }

    public static void registerFluidBehavior(SoftFluid f) {
        Map<Item, SoftFluid.FilledContainerCategory> map = f.getFilledContainersMap();
        for (Item empty : map.keySet()) {
            if (empty != Items.f_41852_ && !REGISTERED_FLUID_ITEMS.contains(empty)) {
                DispenserHelper.registerCustomBehavior(new FillFluidHolderBehavior(empty));
                REGISTERED_FLUID_ITEMS.add(empty);
            }
            for (Item full : map.get(empty).getItems()) {
                if (full == Items.f_41852_ || REGISTERED_FLUID_ITEMS.contains(full)) continue;
                DispenserHelper.registerCustomBehavior(new FillFluidHolderBehavior(full));
                REGISTERED_FLUID_ITEMS.add(full);
            }
        }
    }

    private static ItemStack fillItemInDispenser(BlockSource source, ItemStack empty, ItemStack filled) {
        empty.m_41774_(1);
        if (empty.m_41619_()) {
            return filled.m_41777_();
        }
        if (!DispenserHelper.MergeDispenserItem((DispenserBlockEntity)source.m_8118_(), filled)) {
            SHOOT_BEHAVIOR.m_6115_(source, filled.m_41777_());
        }
        return empty;
    }

    private static boolean MergeDispenserItem(DispenserBlockEntity te, ItemStack filled) {
        NonNullList stacks = te.f_59228_;
        for (int i = 0; i < te.m_6643_(); ++i) {
            ItemStack s = (ItemStack)stacks.get(i);
            if (!s.m_41619_() && (s.m_41720_() != filled.m_41720_() || s.m_41741_() <= s.m_41613_())) continue;
            filled.m_41769_(s.m_41613_());
            te.m_6836_(i, filled);
            return true;
        }
        return false;
    }

    public static abstract class AdditionalDispenserBehavior
    implements DispenseItemBehavior {
        private final DispenseItemBehavior fallback;
        private final Item item;

        protected AdditionalDispenserBehavior(Item item) {
            this.item = item;
            this.fallback = (DispenseItemBehavior)DispenserBlock.f_52661_.get(item);
        }

        public final ItemStack m_6115_(BlockSource source, ItemStack stack) {
            try {
                InteractionResultHolder<ItemStack> result = this.customBehavior(source, stack);
                InteractionResult type = result.m_19089_();
                if (type != InteractionResult.PASS) {
                    boolean success = type.m_19077_();
                    this.playSound(source, success);
                    this.playAnimation(source, (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                    if (success) {
                        ItemStack resultStack = (ItemStack)result.m_19095_();
                        if (resultStack.m_41720_() == stack.m_41720_()) {
                            return resultStack;
                        }
                        return DispenserHelper.fillItemInDispenser(source, stack, (ItemStack)result.m_19095_());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.fallback.m_6115_(source, stack);
        }

        protected abstract InteractionResultHolder<ItemStack> customBehavior(BlockSource var1, ItemStack var2);

        protected void playSound(BlockSource source, boolean success) {
            source.m_7727_().m_46796_(success ? 1000 : 1001, source.m_7961_(), 0);
        }

        protected void playAnimation(BlockSource source, Direction direction) {
            source.m_7727_().m_46796_(2000, source.m_7961_(), direction.m_122411_());
        }
    }

    public static class FillFluidHolderBehavior
    extends AdditionalDispenserBehavior {
        public FillFluidHolderBehavior(Item item) {
            super(item);
        }

        @Override
        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel world = source.m_7727_();
            BlockEntity te = world.m_7702_(blockpos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            if (te instanceof ISoftFluidHolder) {
                ItemStack returnStack;
                SoftFluidHolder tank;
                ISoftFluidHolder tile = (ISoftFluidHolder)te;
                if (tile.canInteractWithFluidHolder() && !(tank = tile.getSoftFluidHolder()).isFull() && (returnStack = tank.interactWithItem(stack, (Level)world, blockpos, false)) != null) {
                    te.m_6596_();
                    return InteractionResultHolder.m_19090_((Object)returnStack);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
    }

    public static class PlaceBlockDispenseBehavior
    extends OptionalDispenseItemBehavior {
        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            this.m_123573_(false);
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos blockpos = source.m_7961_().m_142300_(direction);
                Direction direction1 = source.m_7727_().m_46859_(blockpos.m_7495_()) ? direction : Direction.UP;
                InteractionResult result = ((BlockItem)item).m_40576_((BlockPlaceContext)new DirectionalPlaceContext((Level)source.m_7727_(), blockpos, direction, stack, direction1));
                this.m_123573_(result.m_19077_());
            }
            return stack;
        }
    }

    public static class AddItemToInventoryBehavior
    extends AdditionalDispenserBehavior {
        public AddItemToInventoryBehavior(Item item) {
            super(item);
        }

        @Override
        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel world = source.m_7727_();
            BlockEntity te = world.m_7702_(blockpos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            if (te instanceof WorldlyContainer) {
                WorldlyContainer tile = (WorldlyContainer)te;
                if (tile.m_7013_(0, stack)) {
                    if (tile.m_7983_()) {
                        tile.m_6836_(0, stack.m_41620_(1));
                    } else {
                        tile.m_8020_(0).m_41769_(1);
                        stack.m_41774_(1);
                    }
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
    }
}

