/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.map.markers;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.CustomDecoration;
import net.mehvahdjukaar.selene.map.CustomDecorationType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public abstract class MapWorldMarker<D extends CustomDecoration> {
    private final CustomDecorationType<D, ?> type;
    public BlockPos pos;

    public MapWorldMarker(CustomDecorationType<D, ?> type) {
        this.type = type;
    }

    public void loadFromNBT(CompoundTag compound) {
        this.pos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Pos"));
    }

    public CompoundTag saveToNBT(CompoundTag compound) {
        compound.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)this.getPos()));
        return compound;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            MapWorldMarker marker = (MapWorldMarker)other;
            return Objects.equals(this.getPos(), marker.getPos());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getPos());
    }

    private String getPosSuffix() {
        return this.pos.m_123341_() + "," + this.pos.m_123342_() + "," + this.pos.m_123343_();
    }

    public CustomDecorationType<D, ?> getType() {
        return this.type;
    }

    public String getTypeId() {
        return this.type.getRegistryId();
    }

    public String getMarkerId() {
        return this.getTypeId() + "-" + this.getPosSuffix();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public int getRotation() {
        return 0;
    }

    @Nullable
    protected abstract D doCreateDecoration(byte var1, byte var2, byte var3);

    @Nullable
    public D createDecorationFromMarker(byte scale, int x, int z, ResourceKey<Level> dimension, boolean locked) {
        double worldX = this.getPos().m_123341_();
        double worldZ = this.getPos().m_123343_();
        double rotation = this.getRotation();
        int i = 1 << scale;
        float f = (float)(worldX - (double)x) / (float)i;
        float f1 = (float)(worldZ - (double)z) / (float)i;
        byte mapX = (byte)((double)(f * 2.0f) + 0.5);
        byte mapY = (byte)((double)(f1 * 2.0f) + 0.5);
        if (f >= -64.0f && f1 >= -64.0f && f <= 64.0f && f1 <= 64.0f) {
            byte rot = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            return this.doCreateDecoration(mapX, mapY, rot);
        }
        return null;
    }

    public boolean shouldUpdate(MapWorldMarker<?> other) {
        return false;
    }

    public void updateDecoration(CustomDecoration old) {
    }
}

