/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.example.map;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.example.map.ExampleReg;
import net.mehvahdjukaar.selene.map.CustomDecoration;
import net.mehvahdjukaar.selene.map.markers.MapWorldMarker;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;

public class ExampleMarker
extends MapWorldMarker<CustomDecoration> {
    @Nullable
    private Component name;

    public ExampleMarker() {
        super(ExampleReg.EXAMPLE_DECORATION_TYPE);
    }

    public ExampleMarker(BlockPos pos, Component name) {
        this();
        this.setPos(pos);
        this.name = name;
    }

    @Override
    public CompoundTag saveToNBT(CompoundTag compound) {
        super.saveToNBT(compound);
        if (this.name != null) {
            compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.name));
        }
        return compound;
    }

    @Override
    public void loadFromNBT(CompoundTag compound) {
        super.loadFromNBT(compound);
        this.name = compound.m_128441_("Name") ? Component.Serializer.m_130701_((String)compound.m_128461_("Name")) : null;
    }

    @Nullable
    public static ExampleMarker getFromWorld(BlockGetter world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        BlockEntity blockEntity = tileentity;
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            Component name = sign.m_155706_(0, false);
            return new ExampleMarker(pos, name);
        }
        return null;
    }

    @Override
    @Nullable
    public CustomDecoration doCreateDecoration(byte mapX, byte mapY, byte rot) {
        return new CustomDecoration(this.getType(), mapX, mapY, rot, this.name);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            ExampleMarker marker = (ExampleMarker)other;
            return Objects.equals(this.getPos(), marker.getPos()) && Objects.equals(this.name, marker.name);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPos(), this.name);
    }

    @Override
    public boolean shouldUpdate(MapWorldMarker<?> other) {
        if (other instanceof ExampleMarker) {
            return !Objects.equals(this.name, ((ExampleMarker)other).name);
        }
        return false;
    }

    @Override
    public void updateDecoration(CustomDecoration old) {
        old.setDisplayName(this.name);
    }
}

