/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.blocks;

import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class ItemDisplayTile
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
IOwnerProtected {
    @Nullable
    private UUID owner = null;
    private NonNullList<ItemStack> stacks;
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());

    public ItemDisplayTile(BlockEntityType type, BlockPos pos, BlockState state) {
        this(type, pos, state, 1);
    }

    public ItemDisplayTile(BlockEntityType type, BlockPos pos, BlockState state, int slots) {
        super(type, pos, state);
        this.stacks = NonNullList.m_122780_((int)slots, (Object)ItemStack.f_41583_);
    }

    @Override
    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void m_6596_() {
        if (this.f_58857_ == null) {
            return;
        }
        this.updateTileOnInventoryChanged();
        if (this.needsToUpdateClientWhenChanged()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
        super.m_6596_();
    }

    public void updateTileOnInventoryChanged() {
    }

    public boolean needsToUpdateClientWhenChanged() {
        return true;
    }

    public void updateClientVisualsOnLoad() {
    }

    public ItemStack getDisplayedItem() {
        return this.m_8020_(0);
    }

    public void setDisplayedItem(ItemStack stack) {
        this.m_6836_(0, stack);
    }

    public InteractionResult interact(Player player, InteractionHand handIn) {
        return this.interact(player, handIn, 0);
    }

    public InteractionResult interact(Player player, InteractionHand handIn, int slot) {
        if (!this.isAccessibleBy(player)) {
            player.m_5661_((Component)new TranslatableComponent("container.isLocked", new Object[]{""}), true);
        } else if (handIn == InteractionHand.MAIN_HAND) {
            ItemStack handItem = player.m_21120_(handIn);
            if (!this.m_7983_() && handItem.m_41619_()) {
                ItemStack it = this.m_8016_(slot);
                if (!this.f_58857_.m_5776_()) {
                    player.m_21008_(handIn, it);
                    this.m_6596_();
                } else {
                    this.updateClientVisualsOnLoad();
                }
                return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
            }
            if (!handItem.m_41619_() && this.m_7013_(slot, handItem)) {
                ItemStack it = handItem.m_41777_();
                it.m_41764_(1);
                this.m_6836_(slot, it);
                if (!player.m_7500_()) {
                    handItem.m_41774_(1);
                }
                if (!this.f_58857_.m_5776_()) {
                    this.f_58857_.m_5594_(null, this.f_58858_, this.getAddItemSound(), SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.95f);
                } else {
                    this.updateClientVisualsOnLoad();
                }
                return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.f_12013_;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (!this.m_59631_(compound)) {
            this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        }
        ContainerHelper.m_18980_((CompoundTag)compound, this.stacks);
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                this.updateClientVisualsOnLoad();
            } else {
                this.updateTileOnInventoryChanged();
            }
        }
        this.loadOwner(compound);
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.stacks);
        }
        this.saveOwner(compound);
        return compound;
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 0, this.m_5995_());
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public int m_6893_() {
        return 1;
    }

    public AbstractContainerMenu m_6555_(int id, Inventory player) {
        return ChestMenu.m_39237_((int)id, (Inventory)player, (Container)this);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.stacks;
    }

    public void m_6520_(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.m_7983_();
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return false;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public int[] m_7071_(Direction side) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlers[facing.ordinal()].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

