/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.map;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.CustomDecorationType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public class CustomDecoration {
    private final CustomDecorationType<?, ?> type;
    private ITextComponent displayName;
    private byte x;
    private byte y;
    private byte rot;

    public CustomDecoration(CustomDecorationType<?, ?> type, byte x, byte y, byte rot, @Nullable ITextComponent displayName) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.rot = rot;
        this.displayName = displayName;
    }

    public CustomDecorationType<?, ?> getType() {
        return this.type;
    }

    public String getTypeId() {
        return this.type.getRegistryId();
    }

    public byte getX() {
        return this.x;
    }

    public byte getY() {
        return this.y;
    }

    public byte getRot() {
        return this.rot;
    }

    public void setDisplayName(ITextComponent displayName) {
        this.displayName = displayName;
    }

    public void setRot(byte rot) {
        this.rot = rot;
    }

    public void setX(byte x) {
        this.x = x;
    }

    public void setY(byte y) {
        this.y = y;
    }

    @Nullable
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CustomDecoration)) {
            return false;
        }
        CustomDecoration mapdecoration = (CustomDecoration)obj;
        if (this.type != mapdecoration.type) {
            return false;
        }
        if (this.rot != mapdecoration.rot) {
            return false;
        }
        if (this.x != mapdecoration.x) {
            return false;
        }
        if (this.y != mapdecoration.y) {
            return false;
        }
        return Objects.equals(this.displayName, mapdecoration.displayName);
    }

    public int hashCode() {
        int i = this.type.getId().hashCode();
        i = 31 * i + this.x;
        i = 31 * i + this.y;
        i = 31 * i + this.rot;
        return 31 * i + Objects.hashCode(this.displayName);
    }

    public void saveToBuffer(PacketBuffer buffer) {
        buffer.writeByte((int)this.getX());
        buffer.writeByte((int)this.getY());
        buffer.writeByte(this.getRot() & 0xF);
        if (this.getDisplayName() != null) {
            buffer.writeBoolean(true);
            buffer.func_179256_a(this.getDisplayName());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public CustomDecoration(CustomDecorationType<?, ?> type, PacketBuffer buffer) {
        this(type, buffer.readByte(), buffer.readByte(), (byte)(buffer.readByte() & 0xF), buffer.readBoolean() ? buffer.func_179258_d() : null);
    }
}

