/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1690;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2478;
import net.minecraft.class_2941;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_7713;
import net.minecraft.class_7923;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodType
extends BlockType {
    public static Codec<WoodType> CODEC;
    public static class_9139<ByteBuf, WoodType> STREAM_CODEC;
    public static Supplier<class_2941<WoodType>> ENTITY_SERIALIZER;
    public final class_2248 planks;
    public final class_2248 log;
    private final Supplier<class_4719> vanillaType = Suppliers.memoize(this::detectVanillaWood);
    private final Supplier<class_1690.class_1692> boatType = Suppliers.memoize(this::detectVanillaBoat);

    @Nullable
    private class_1690.class_1692 detectVanillaBoat() {
        if (this == VanillaWoodTypes.OAK) {
            return class_1690.class_1692.field_7727;
        }
        class_2960 id = this.getId();
        Set<String> conventions = Set.of(id.method_12832(), id.method_12836() + id.method_12832(), id.method_12836() + "_" + id.method_12832(), id.method_12836() + "/" + id.method_12832(), id.toString());
        for (String s : conventions) {
            class_1690.class_1692 o = class_1690.class_1692.method_7561((String)s);
            if (o == class_1690.class_1692.field_7727) continue;
            return o;
        }
        return null;
    }

    @Nullable
    private class_4719 detectVanillaWood() {
        Object object = this.getChild("hanging_sign");
        if (object instanceof class_7713) {
            class_7713 c = (class_7713)object;
            return c.method_24025();
        }
        object = this.getChild("sign");
        if (object instanceof class_2478) {
            class_2478 f = (class_2478)object;
            return f.method_24025();
        }
        String i = this.id.method_12836().equals("minecraft") ? this.id.method_12832() : this.id.toString();
        Stream values = class_4719.method_24026();
        Optional<class_4719> o = values.filter(v -> v.comp_1299().equals(i)).findAny();
        return o.orElse(null);
    }

    public WoodType(class_2960 id, class_2248 baseBlock, class_2248 logBlock) {
        super(id);
        this.planks = baseBlock;
        this.log = logBlock;
    }

    @Override
    public class_1935 mainChild() {
        return this.planks;
    }

    @Nullable
    public class_4719 toVanilla() {
        return this.vanillaType.get();
    }

    @Nullable
    public class_1690.class_1692 toVanillaBoat() {
        return this.boatType.get();
    }

    @NotNull
    public class_4719 toVanillaOrOak() {
        class_4719 v = this.toVanilla();
        if (v != null) {
            return v;
        }
        return class_4719.field_21676;
    }

    @NotNull
    public class_1690.class_1692 toVanillaBoatOrOak() {
        class_1690.class_1692 v = this.toVanillaBoat();
        if (v != null) {
            return v;
        }
        return class_1690.class_1692.field_7727;
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getTypeName();
        }
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.planks.method_9564().method_50011();
    }

    public class_3620 getColor() {
        return this.planks.method_26403();
    }

    @Override
    public String getTranslationKey() {
        return "wood_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("planks", this.planks);
        this.addChild("log", this.log);
        this.addChild("leaves", this.findRelatedEntry("leaves", class_7923.field_41175));
        this.addChild("wood", this.findLogRelatedBlock("", "wood", "hyphae", "bark"));
        this.addChild("stripped_log", this.findStrippedLog("log", "stem", "stalk"));
        this.addChild("stripped_wood", this.findStrippedLog("wood", "hyphae", "bark"));
        this.addChild("slab", this.findRelatedEntry("slab", class_7923.field_41175));
        this.addChild("stairs", this.findRelatedEntry("stairs", class_7923.field_41175));
        class_2248 fence = (class_2248)this.findRelatedEntry("fence", class_7923.field_41175);
        this.addChild("fence", fence);
        this.addChild("fence_gate", this.findRelatedEntry("fence_gate", class_7923.field_41175));
        this.addChild("door", this.findRelatedEntry("door", class_7923.field_41175));
        this.addChild("trapdoor", this.findRelatedEntry("trapdoor", class_7923.field_41175));
        this.addChild("button", this.findRelatedEntry("button", class_7923.field_41175));
        this.addChild("pressure_plate", this.findRelatedEntry("pressure_plate", class_7923.field_41175));
        this.addChild("hanging_sign", this.findRelatedEntry("hanging_sign", class_7923.field_41175));
        this.addChild("wall_hanging_sign", this.findRelatedEntry("wall_hanging_sign", class_7923.field_41175));
        this.addChild("sign", this.findRelatedEntry("sign", class_7923.field_41175));
        this.addChild("wall_sign", this.findRelatedEntry("wall_sign", class_7923.field_41175));
        if (this.id.method_12836().matches("tfc|afc")) {
            this.addChild("sign", this.findRelatedEntry("sign", "", (class_2378)class_7923.field_41175));
            this.addChild("hanging_sign", this.findRelatedEntry("hanging_sign/wrought_sign", "", (class_2378)class_7923.field_41175));
        }
        if (fence != null && CompatHandler.DIAGONALFENCES) {
            Optional diagonalFence = class_7923.field_41175.method_17966(class_2960.method_60655((String)"diagonalfences", (String)Utils.getID(fence).toString().replace(":", "/")));
            diagonalFence.ifPresent(block -> this.addChild("diagonalfences:fence", block));
        }
    }

    @Override
    public void initializeChildrenItems() {
        if (this.id.toString().equals("minecraft:bamboo")) {
            this.addChild("boat", this.findRelatedEntry("raft", class_7923.field_41178));
            this.addChild("chest_boat", this.findRelatedEntry("chest_raft", class_7923.field_41178));
        } else {
            this.addChild("boat", this.findRelatedItem("boat", "raft"));
            this.addChild("chest_boat", this.findRelatedItem("chest_boat", "chest_raft"));
        }
        this.addChild("sapling", this.findRelatedEntry("sapling", class_7923.field_41178));
        if (this.id.method_12836().matches("tfc|afc")) {
            this.addChild("stick", this.findRelatedEntry("twig", class_7923.field_41175));
            this.addChild("boat", this.findRelatedEntry("boat", "", (class_2378)class_7923.field_41175));
        }
    }

    @Override
    @Nullable
    protected <V> V findRelatedEntry(String prefix, String suffix, class_2378<V> reg) {
        if (!((String)suffix).isEmpty()) {
            suffix = "_" + (String)suffix;
        }
        class_2960[] targets = new class_2960[]{class_2960.method_60655((String)this.id.method_12836(), (String)(this.id.method_12832() + "_" + prefix + (String)suffix)), class_2960.method_60655((String)this.id.method_12836(), (String)(prefix + "_" + this.id.method_12832() + (String)suffix)), this.id.method_45136(this.id.method_12832() + "_planks_" + prefix + (String)suffix), this.id.method_45136("wood/planks/" + this.id.method_12832() + "_" + prefix), this.id.method_45136("wood/" + prefix + (String)suffix + "/" + this.id.method_12832())};
        return Utils.findFirstInRegistry(reg, targets);
    }

    @Nullable
    protected class_2248 findStrippedLog(String ... possibleNames) {
        for (String v : possibleNames) {
            class_2248 stripped;
            class_2248 b = this.getBlockOfThis(v);
            if (v == null || (stripped = (class_2248)class_1743.field_7898.get(b)) == null || stripped == b) continue;
            return stripped;
        }
        return this.findLogRelatedBlock("stripped", possibleNames);
    }

    @Nullable
    protected class_1792 findRelatedItem(String ... names) {
        for (String n : names) {
            class_1792 b = (class_1792)this.findRelatedEntry(n, class_7923.field_41178);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @Nullable
    protected class_2248 findLogRelatedBlock(String prefix, String ... possibleSuffix) {
        for (String n : possibleSuffix) {
            class_2248 b = this.findLogWithPrefix(prefix, n);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @Nullable
    protected class_2248 findLogWithPrefix(String prefix, String suffix) {
        if (this.id.method_12836().matches("tfc|afc")) {
            Object prefix_ = prefix.isEmpty() ? "" : prefix + "_";
            Optional o = class_7923.field_41175.method_17966(class_2960.method_60655((String)this.getNamespace(), (String)("wood/" + (String)prefix_ + suffix + "/" + this.id.method_12832())));
            if (o.isPresent()) {
                return (class_2248)o.get();
            }
        }
        List<class_2960> targets = WoodType.makeKnownIDConventionsPrefix(this.id.method_12836(), this.id.method_12832(), prefix, suffix, Utils.getID(this.log).method_12832());
        return (class_2248)Utils.findFirstInRegistry(class_7923.field_41175, targets);
    }

    @NotNull
    private static List<class_2960> makeKnownIDConventionsPrefix(String myNamespace, String myPath, String prefix, String suffix, String alternateNamespace) {
        boolean noneEmpty = !prefix.isEmpty() && !suffix.isEmpty();
        Object prefix_ = prefix.isEmpty() ? "" : prefix + "_";
        ArrayList<class_2960> targets = new ArrayList<class_2960>();
        targets.add(class_2960.method_60655((String)myNamespace, (String)(myPath + "_" + (String)prefix_ + suffix)));
        targets.add(class_2960.method_60655((String)myNamespace, (String)(alternateNamespace + "_" + (String)prefix_ + suffix)));
        if (!noneEmpty) {
            targets.add(class_2960.method_60655((String)myNamespace, (String)((String)prefix_ + myPath + "_" + suffix)));
            targets.add(class_2960.method_60655((String)myNamespace, (String)((String)prefix_ + alternateNamespace + "_" + suffix)));
        }
        if (myPath.endsWith(suffix)) {
            targets.add(class_2960.method_60655((String)myNamespace, (String)((String)prefix_ + myPath)));
        }
        return targets;
    }

    static List<class_2960> makeKnownIDConventions(class_2960 id, String ... suffixKeyword) {
        String myPath = id.method_12832();
        String myNamespace = id.method_12836();
        ArrayList<class_2960> resources = new ArrayList<class_2960>();
        for (String suffix : suffixKeyword) {
            resources.addAll(WoodType.makeKnownIDConventionsPrefix(myNamespace, myPath, "", suffix, myPath));
        }
        return resources;
    }

    @Nullable
    static class_2248 findLog(class_2960 id) {
        List<class_2960> tests = WoodType.makeKnownIDConventions(id, "log", "stem", "stalk", "hyphae");
        return (class_2248)Utils.findFirstInRegistry(class_7923.field_41175, tests);
    }

    @Nullable
    static class_2248 findPlanks(class_2960 id) {
        List<class_2960> tests = WoodType.makeKnownIDConventions(id, "planks", "plank");
        return (class_2248)Utils.findFirstInRegistry(class_7923.field_41175, tests);
    }

    public class_4970.class_2251 copyProperties() {
        class_4970.class_2251 p = class_4970.class_2251.method_9637();
        p.method_31710(this.getColor());
        if (this.canBurn()) {
            p.method_50013();
        }
        p.method_9626(this.getSound());
        return p;
    }

    static {
        WoodTypeRegistry.touch();
    }

    public static class Finder
    extends BlockType.SetFinderBuilder<WoodType> {
        private Supplier<class_2248> planksFinder;
        private Supplier<class_2248> logFinder;

        public Finder(class_2960 id) {
            super(id, WoodTypeRegistry.INSTANCE);
            this.log(() -> WoodType.findLog(id));
            this.planks(() -> WoodType.findPlanks(id));
        }

        public Finder planks(Supplier<class_2248> planksFinder) {
            this.planksFinder = planksFinder;
            return this;
        }

        public Finder planks(class_2960 id) {
            return this.planks(() -> (class_2248)class_7923.field_41175.method_17966(id).orElseThrow(() -> new IllegalStateException("Failed to find planks block: " + String.valueOf(id))));
        }

        public Finder planks(String planksName) {
            return this.planks(Utils.idWithOptionalNamespace(planksName, this.id.method_12836()));
        }

        public Finder planksAffix(String prefix, String suffix) {
            return this.planks(prefix + this.id.method_12832() + suffix);
        }

        public Finder planksSuffix(String suffix) {
            return this.planks(this.id.method_12832() + suffix);
        }

        public Finder log(Supplier<class_2248> logFinder) {
            this.logFinder = logFinder;
            return this;
        }

        public Finder log(class_2960 id) {
            return this.log(() -> (class_2248)class_7923.field_41175.method_17966(id).orElseThrow(() -> new IllegalStateException("Failed to find log block: " + String.valueOf(id))));
        }

        public Finder log(String nameLog) {
            return this.log(Utils.idWithOptionalNamespace(nameLog, this.id.method_12836()));
        }

        public Finder logAffix(String prefix, String suffix) {
            return this.log(prefix + this.id.method_12832() + suffix);
        }

        public Finder logSuffix(String suffix) {
            return this.log(this.id.method_12832() + suffix);
        }

        @Override
        @ApiStatus.Internal
        public Optional<WoodType> get() {
            if (PlatHelper.isModLoaded(this.id.method_12836())) {
                try {
                    class_2248 plank = (class_2248)Preconditions.checkNotNull((Object)this.planksFinder.get(), (String)"Manual Finder - failed to find a plank block for {}", (Object)this.id);
                    class_2248 log = (class_2248)Preconditions.checkNotNull((Object)this.logFinder.get(), (String)"Manual Finder - failed to find a log block for {}", (Object)this.id);
                    WoodType woodType = new WoodType(this.id, plank, log);
                    this.childNames.forEach((key, value) -> {
                        try {
                            class_1935 obj = (class_1935)Preconditions.checkNotNull((Object)((class_1935)value.get()));
                            woodType.addChild((String)key, obj);
                        }
                        catch (Exception e) {
                            Moonlight.LOGGER.warn("Failed to find child for WoodType: {} - {}. Ignored! ERROR: {}", (Object)this.id, key, (Object)e.getMessage());
                        }
                    });
                    return Optional.of(woodType);
                }
                catch (Exception e) {
                    Moonlight.LOGGER.warn("Failed to find custom WoodType:  {} - ", (Object)this.id, (Object)e);
                }
            }
            return Optional.empty();
        }

        @Deprecated(forRemoval=true)
        public Finder(class_2960 id, Supplier<class_2248> planks, Supplier<class_2248> log) {
            super(id, WoodTypeRegistry.INSTANCE);
            this.planksFinder = planks;
            this.logFinder = log;
        }

        @Deprecated(forRemoval=true)
        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(class_2960.method_60655((String)modId, (String)woodTypeName), class_2960.method_60655((String)modId, (String)planksName), class_2960.method_60655((String)modId, (String)logName));
        }

        @Deprecated(forRemoval=true)
        public static Finder simple(class_2960 woodTypeName, class_2960 planksName, class_2960 logName) {
            return new Finder(woodTypeName, () -> (class_2248)class_7923.field_41175.method_10223(planksName), () -> (class_2248)class_7923.field_41175.method_10223(logName));
        }

        @Deprecated(forRemoval=true)
        public void addChild(String childType, String childName) {
            this.childBlock(childType, childName);
        }

        @Deprecated(forRemoval=true)
        public void addChild(String childType, class_2960 childName) {
            this.childBlock(childType, childName);
        }
    }
}

