/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.ConfigValue;
import net.mehvahdjukaar.moonlight.core.Moonlight;

public class ObjectConfigValue<T>
extends ConfigValue<T> {
    private final Codec<T> codec;
    private final Supplier<T> lazyDefault;

    public ObjectConfigValue(String name, Supplier<T> defaultValue, Codec<T> codec) {
        super(name, null);
        this.codec = codec;
        this.lazyDefault = Suppliers.memoize(defaultValue);
    }

    @Override
    public boolean isValid(T value) {
        return true;
    }

    @Override
    public void loadFromJson(JsonObject element) {
        if (element.has(this.name)) {
            try {
                JsonElement j = element.get(this.name);
                DataResult e = this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)j);
                Optional json = e.resultOrPartial(s -> Moonlight.LOGGER.warn("Failed to parse config {}: {}", (Object)this.name, s));
                if (json.isPresent()) {
                    this.value = ((Pair)json.get()).getFirst();
                    return;
                }
                Moonlight.LOGGER.warn("Config file had incorrect entry {}, correcting ", (Object)this.name);
                this.value = this.defaultValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
            Moonlight.LOGGER.warn("Config file had incorrect entry {}, correcting", (Object)this.name);
        } else {
            Moonlight.LOGGER.warn("Config file had missing entry {}", (Object)this.name);
        }
    }

    @Override
    public T getDefaultValue() {
        return (T)this.lazyDefault.get();
    }

    @Override
    public void saveToJson(JsonObject object) {
        if (this.value == null) {
            this.value = this.getDefaultValue();
        }
        DataResult e = this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.value);
        Optional json = e.resultOrPartial(s -> {
            throw new RuntimeException("Failed to parse config " + this.name + ": " + s);
        });
        json.ifPresent(jsonElement -> object.add(this.name, jsonElement));
    }
}

