/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.ArrayList;
import java.util.List;

public interface IProgressTracker {
    public Task subtask(int var1);

    public static Tree createTree(int totalSteps) {
        return new Tree(totalSteps);
    }

    public static class Tree
    implements Task {
        private final List<Tree> subtasks = new ArrayList<Tree>();
        private final int totalSteps;
        private int completedSteps = 0;

        public Tree(int totalSteps) {
            this.totalSteps = totalSteps;
        }

        @Override
        public synchronized Task subtask(int totalSteps) {
            Tree subtask = new Tree(totalSteps);
            this.subtasks.add(subtask);
            return subtask;
        }

        @Override
        public synchronized void step() {
            if (this.completedSteps < this.totalSteps) {
                ++this.completedSteps;
            }
        }

        public float getProgress() {
            if (this.totalSteps == 0) {
                return 1.0f;
            }
            if (this.subtasks.isEmpty()) {
                return (float)this.completedSteps / (float)this.totalSteps;
            }
            float sum = 0.0f;
            for (Tree sub : this.subtasks) {
                sum += sub.getProgress();
            }
            return sum / (float)this.subtasks.size();
        }

        public int countLeaves() {
            if (this.subtasks.isEmpty()) {
                return 1;
            }
            int sum = 0;
            for (Tree sub : this.subtasks) {
                sum += sub.countLeaves();
            }
            return sum;
        }
    }

    public static interface Task
    extends IProgressTracker {
        public void step();
    }
}

