/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.forge;

import com.google.gson.JsonParser;
import java.lang.ref.WeakReference;
import net.mehvahdjukaar.moonlight.api.client.model.RetexturedModelLoader;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.fake_player.FPClientAccess;
import net.mehvahdjukaar.moonlight.core.misc.forge.ModLootConditions;
import net.mehvahdjukaar.moonlight.core.misc.forge.ModLootModifiers;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundSendLoginPacket;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.mehvahdjukaar.moonlight.forge.MoonlightForgeClient;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="moonlight")
public class MoonlightForge {
    public static final String MOD_ID = "moonlight";
    @Nullable
    private static WeakReference<ICondition.IContext> context = null;

    public MoonlightForge() {
        Moonlight.commonInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLootModifiers.register();
        ModLootConditions.register();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        if (PlatHelper.getPhysicalSide().isClient()) {
            modEventBus.addListener(MoonlightForgeClient::registerShader);
            modEventBus.addListener(MoonlightForgeClient::clientSetup);
            MoonlightClient.initClient();
            ClientHelper.addModelLoaderRegistration(modelLoaderEvent -> modelLoaderEvent.register(Moonlight.res("lazy_copy"), new RetexturedModelLoader()));
        }
    }

    @SubscribeEvent
    public void onTagUpdated(TagsUpdatedEvent event) {
        Moonlight.afterDataReload(event.getRegistryAccess());
    }

    @Nullable
    public static ICondition.IContext getConditionContext() {
        if (context == null) {
            return null;
        }
        return (ICondition.IContext)context.get();
    }

    @SubscribeEvent
    public void onResourceReload(AddReloadListenerEvent event) {
        context = new WeakReference<ICondition.IContext>(event.getConditionContext());
    }

    @SubscribeEvent
    public void onDataSync(OnDatapackSyncEvent event) {
        SoftFluidRegistry.onDataLoad();
        if (event.getPlayer() != null) {
            SoftFluidRegistry.onDataSyncToPlayer(event.getPlayer(), true);
        } else {
            for (ServerPlayer p : event.getPlayerList().m_11314_()) {
                SoftFluidRegistry.onDataSyncToPlayer(p, true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            try {
                ModMessages.CHANNEL.sendToClientPlayer(player2, new ClientBoundSendLoginPacket());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDimensionUnload(LevelEvent.Unload event) {
        LevelAccessor level = event.getLevel();
        try {
            if (level.m_5776_()) {
                FPClientAccess.unloadLevel(level);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Moonlight.onPlayerCloned(event.getOriginal(), event.getEntity(), event.isWasDeath());
    }

    public static class aa
    extends DynClientResourcesGenerator {
        protected aa(DynamicTexturePack pack) {
            super(pack);
            pack.addNamespaces("minecraft");
        }

        @Override
        public Logger getLogger() {
            return Moonlight.LOGGER;
        }

        @Override
        public boolean dependsOnLoadedPacks() {
            return true;
        }

        @Override
        public void regenerateDynamicAssets(ResourceManager manager) {
            for (Block b : BuiltInRegistries.f_256975_) {
                ResourceLocation id;
                if (!(b instanceof StairBlock) || (id = Utils.getID(b)).m_135815_().equals("oak_stairs")) continue;
                ResourceLocation location = new ResourceLocation(id.m_135827_(), id.m_135815_());
                ((DynamicTexturePack)this.dynamicPack).addBlockModel(location, JsonParser.parseString((String)"{\n  \"loader\": \"moonlight:lazy_copy\",\n  \"parent_block\": \"minecraft:oak_stairs\",\n  \"parent_model\": \"minecraft:block/stairs\",\n  \"textures\": {\n    \"bottom\": \"minecraft:block/dark_oak_planks\",\n    \"side\": \"minecraft:block/dark_oak_planks\",\n    \"top\": \"minecraft:block/dark_oak_planks\"\n  }\n}\n".replace("dark_oak", id.m_135815_().replace("_stairs", ""))));
                location = new ResourceLocation(id.m_135827_(), id.m_135815_() + "_inner");
                ((DynamicTexturePack)this.dynamicPack).addBlockModel(location, JsonParser.parseString((String)"{\n  \"loader\": \"moonlight:lazy_copy\",\n  \"parent_block\": \"minecraft:oak_stairs\",\n  \"parent_model\": \"minecraft:block/inner_stairs\",\n  \"textures\": {\n    \"bottom\": \"minecraft:block/dark_oak_planks\",\n    \"side\": \"minecraft:block/dark_oak_planks\",\n    \"top\": \"minecraft:block/dark_oak_planks\"\n  }\n}\n".replace("dark_oak", id.m_135815_().replace("_stairs", ""))));
                location = new ResourceLocation(id.m_135827_(), id.m_135815_() + "_outer");
                ((DynamicTexturePack)this.dynamicPack).addBlockModel(location, JsonParser.parseString((String)"{\n  \"loader\": \"moonlight:lazy_copy\",\n  \"parent_block\": \"minecraft:oak_stairs\",\n  \"parent_model\": \"minecraft:block/outer_stairs\",\n  \"textures\": {\n    \"bottom\": \"minecraft:block/dark_oak_planks\",\n    \"side\": \"minecraft:block/dark_oak_planks\",\n    \"top\": \"minecraft:block/dark_oak_planks\"\n  }\n}\n".replace("dark_oak", id.m_135815_().replace("_stairs", ""))));
            }
        }
    }
}

