/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class CaveFilter
extends PlacementFilter {
    public static final Codec<CaveFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Heightmap.Types.f_64274_.listOf().fieldOf("heightmaps").forGetter(p -> p.belowHeightMaps), (App)Codec.BOOL.fieldOf("below_sea_level").forGetter(p -> p.belowSeaLevel)).apply((Applicative)instance, CaveFilter::new));
    private final List<Heightmap.Types> belowHeightMaps;
    private final Boolean belowSeaLevel;

    private CaveFilter(List<Heightmap.Types> types, Boolean belowSeaLevel) {
        this.belowHeightMaps = types;
        this.belowSeaLevel = belowSeaLevel;
    }

    protected boolean m_213917_(PlacementContext context, RandomSource random, BlockPos pos) {
        ChunkSource chunkSource = context.m_191831_().m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            int sea;
            ServerChunkCache serverChunkCache = (ServerChunkCache)chunkSource;
            int y = pos.m_123342_();
            if (this.belowSeaLevel.booleanValue() && y > (sea = serverChunkCache.m_8481_().m_6337_())) {
                return false;
            }
            for (Heightmap.Types h : this.belowHeightMaps) {
                int k = context.m_191824_(h, pos.m_123341_(), pos.m_123343_());
                if (y <= k) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public PlacementModifierType<?> m_183327_() {
        return Moonlight.CAVE_MODIFIER.get();
    }

    public static class Type
    implements PlacementModifierType<CaveFilter> {
        public Codec<CaveFilter> m_191869_() {
            return CODEC;
        }
    }
}

