/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.forge.SoftFluidTankImpl;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SoftFluidTank {
    public static final String POTION_TYPE_KEY = "Bottle";
    public static final int BOTTLE_COUNT = 1;
    public static final int BOWL_COUNT = 2;
    public static final int BUCKET_COUNT = 4;
    protected int count = 0;
    protected final int capacity;
    @Nullable
    protected CompoundTag nbt = null;
    protected SoftFluid fluid = BuiltInSoftFluids.EMPTY.get();
    protected int specialColor = 0;
    protected boolean needsColorRefresh = true;

    protected SoftFluidTank(int capacity) {
        this.capacity = capacity;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SoftFluidTank create(int capacity) {
        return SoftFluidTankImpl.create(capacity);
    }

    public boolean interactWithPlayer(Player player, InteractionHand hand, @Nullable Level world, @Nullable BlockPos pos) {
        ItemStack handStack = player.m_21120_(hand);
        ItemStack returnStack = this.interactWithItem(handStack, world, pos, false);
        if (returnStack != null) {
            Utils.swapItem(player, hand, returnStack);
            if (!handStack.m_41619_()) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)handStack.m_41720_()));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public ItemStack interactWithItem(ItemStack stack, @Nullable Level world, @Nullable BlockPos pos, boolean simulate) {
        ItemStack returnStack = this.tryFillingItem(stack.m_41720_(), world, pos, simulate);
        if (returnStack != null) {
            return returnStack;
        }
        returnStack = this.tryDrainItem(stack, world, pos, simulate);
        return returnStack;
    }

    public ItemStack tryDrainItem(ItemStack filledContainerStack, @Nullable Level world, @Nullable BlockPos pos, boolean simulate) {
        return this.tryDrainItem(filledContainerStack, world, pos, simulate, true);
    }

    @Nullable
    public ItemStack tryDrainItem(ItemStack filledContainerStack, @Nullable Level world, @Nullable BlockPos pos, boolean simulate, boolean playSound) {
        FluidContainerList.Category category;
        int amount;
        Optional<FluidContainerList.Category> optionalCategory;
        boolean hasCustomPot;
        Item filledContainer = filledContainerStack.m_41720_();
        SoftFluid s = SoftFluidRegistry.fromItem(filledContainer);
        if (s.isEmpty()) {
            return null;
        }
        CompoundTag com = filledContainerStack.m_41783_();
        CompoundTag newCom = new CompoundTag();
        Potion potion = PotionUtils.m_43579_((ItemStack)filledContainerStack);
        boolean bl = hasCustomPot = com != null && com.m_128441_("CustomPotionEffects");
        if (potion == Potions.f_43599_ && !hasCustomPot) {
            s = BuiltInSoftFluids.WATER.get();
        } else if (potion != Potions.f_43598_ || hasCustomPot) {
            this.addPotionTag(filledContainer, newCom);
        }
        if (com != null) {
            for (String k : s.getNbtKeyFromItem()) {
                Tag c = com.m_128423_(k);
                if (c == null) continue;
                newCom.m_128365_(k, c);
            }
        }
        if (this.isEmpty()) {
            this.setFluid(s, newCom.m_128456_() ? null : newCom);
        }
        if ((optionalCategory = s.getContainerList().getCategoryFromFilled(filledContainer)).isPresent() && this.canAddSoftFluid(s, amount = (category = optionalCategory.get()).getAmount(), newCom)) {
            if (simulate) {
                return ItemStack.f_41583_;
            }
            this.grow(amount);
            SoundEvent sound = category.getEmptySound();
            if (sound != null && world != null && pos != null) {
                world.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return new ItemStack((ItemLike)category.getEmptyContainer());
        }
        return null;
    }

    public ItemStack tryFillingItem(Item emptyContainer, @Nullable Level world, @Nullable BlockPos pos, boolean simulate) {
        return this.tryFillingItem(emptyContainer, world, pos, simulate, true);
    }

    @Nullable
    public ItemStack tryFillingItem(Item emptyContainer, @Nullable Level world, @Nullable BlockPos pos, boolean simulate, boolean playSound) {
        FluidContainerList.Category category;
        int amount;
        Optional<FluidContainerList.Category> opt = this.fluid.getContainerList().getCategoryFromEmpty(emptyContainer);
        if (opt.isPresent() && this.canRemove(amount = (category = opt.get()).getAmount())) {
            if (simulate) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = new ItemStack((ItemLike)category.getFirstFilled().get());
            if (this.fluid == BuiltInSoftFluids.POTION.get() && this.nbt != null && this.nbt.m_128441_(POTION_TYPE_KEY) && !Utils.getID(emptyContainer).m_135827_().equals("inspirations")) {
                String bottle = this.nbt.m_128461_(POTION_TYPE_KEY);
                if (bottle.equals("SPLASH")) {
                    stack = new ItemStack((ItemLike)Items.f_42736_);
                } else if (bottle.equals("LINGERING")) {
                    stack = new ItemStack((ItemLike)Items.f_42739_);
                }
            }
            if (emptyContainer == Items.f_42590_ && this.fluid == BuiltInSoftFluids.WATER.get()) {
                stack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
            }
            this.applyNBTtoItemStack(stack);
            this.shrink(amount);
            SoundEvent sound = category.getEmptySound();
            if (sound != null && world != null && pos != null) {
                world.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return stack;
        }
        return null;
    }

    @Nullable
    public ItemStack tryFillingBottle(Level world, BlockPos pos) {
        return this.tryFillingItem(Items.f_42590_, world, pos, false);
    }

    @Nullable
    public ItemStack tryFillingBucket(Level world, BlockPos pos) {
        return this.tryFillingItem(Items.f_42446_, world, pos, false);
    }

    @Nullable
    public ItemStack tryFillingBowl(Level world, BlockPos pos) {
        return this.tryFillingItem(Items.f_42399_, world, pos, false);
    }

    public boolean isSameFluidAs(SoftFluid other) {
        return this.isSameFluidAs(other, null);
    }

    public boolean isSameFluidAs(SoftFluid other, @Nullable CompoundTag com) {
        return this.getFluid().equals(other) && SoftFluidTank.areNbtEquals(this.getNbt(), com);
    }

    public boolean tryAddingFluid(SoftFluid s, int count, @Nullable CompoundTag com) {
        if (this.canAdd(count)) {
            if (this.isEmpty()) {
                this.setFluid(s, com);
                this.setCount(count);
                return true;
            }
            if (this.isSameFluidAs(s, com)) {
                this.grow(count);
                return true;
            }
        }
        return false;
    }

    public boolean tryAddingFluid(SoftFluid s, int count) {
        return this.tryAddingFluid(s, count, null);
    }

    public boolean tryAddingFluid(SoftFluid s) {
        return this.tryAddingFluid(s, 1);
    }

    public boolean tryTransferFluid(SoftFluidTank destination) {
        return this.tryTransferFluid(destination, 1);
    }

    public boolean tryTransferFluid(SoftFluidTank destination, int amount) {
        if (destination.canAdd(amount) && this.canRemove(amount)) {
            if (destination.isEmpty()) {
                destination.setFluid(this.getFluid(), this.getNbt());
                this.shrink(amount);
                destination.grow(amount);
                return true;
            }
            if (this.isSameFluidAs(destination.getFluid(), destination.getNbt())) {
                this.shrink(amount);
                destination.grow(amount);
                return true;
            }
        }
        return false;
    }

    public boolean canRemove(int n) {
        return this.count >= n && !this.isEmpty();
    }

    public boolean canAdd(int n) {
        return this.count + n <= this.capacity;
    }

    public boolean canAddSoftFluid(SoftFluid s, int count) {
        return this.canAddSoftFluid(s, count, null);
    }

    public boolean canAddSoftFluid(SoftFluid s, int count, @Nullable CompoundTag nbt) {
        return this.canAdd(count) && this.isSameFluidAs(s, nbt);
    }

    public boolean isFull() {
        return this.count == this.capacity;
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty() || this.count <= 0;
    }

    public void lossyAdd(int inc) {
        this.count = Math.min(this.capacity, this.count + inc);
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void fillCount() {
        this.setCount(this.capacity);
    }

    public void grow(int inc) {
        this.setCount(this.count + inc);
    }

    public void shrink(int inc) {
        this.grow(-inc);
        if (this.count == 0) {
            this.clear();
        }
    }

    public float getHeight(float maxHeight) {
        return maxHeight * (float)this.count / (float)this.capacity;
    }

    public int getComparatorOutput() {
        float f = (float)this.count / (float)this.capacity;
        return Mth.m_14143_((float)(f * 14.0f)) + 1;
    }

    public int getCount() {
        return this.count;
    }

    @NotNull
    public SoftFluid getFluid() {
        return this.fluid;
    }

    @Nullable
    public CompoundTag getNbt() {
        return this.nbt;
    }

    public void setNbt(@Nullable CompoundTag nbt) {
        this.nbt = nbt;
    }

    public void clear() {
        this.fluid = BuiltInSoftFluids.EMPTY.get();
        this.setCount(0);
        this.nbt = null;
        this.specialColor = 0;
    }

    public void copy(SoftFluidTank other) {
        this.setFluid(other.getFluid(), other.getNbt());
        this.setCount(Math.min(this.capacity, other.getCount()));
    }

    public void fill(SoftFluid fluid) {
        this.fill(fluid, null);
    }

    public void fill(SoftFluid fluid, @Nullable CompoundTag nbt) {
        this.setFluid(fluid, nbt);
        this.fillCount();
    }

    public void setFluid(@NotNull SoftFluid fluid) {
        this.setFluid(fluid, null);
    }

    public void setFluid(@NotNull SoftFluid fluid, @Nullable CompoundTag nbt) {
        this.fluid = fluid;
        if (fluid == null) {
            boolean bl = true;
        }
        this.nbt = null;
        if (nbt != null) {
            this.nbt = nbt.m_6426_();
            if (fluid.equals(BuiltInSoftFluids.POTION.get()) && !this.nbt.m_128441_(POTION_TYPE_KEY)) {
                this.nbt.m_128359_(POTION_TYPE_KEY, "REGULAR");
            }
        }
        this.specialColor = 0;
        if (this.fluid.isEmpty()) {
            this.setCount(0);
        }
        this.needsColorRefresh = true;
    }

    public abstract int getTintColor(@Nullable LevelReader var1, @Nullable BlockPos var2);

    public abstract int getFlowingTint(@Nullable LevelReader var1, @Nullable BlockPos var2);

    public abstract int getParticleColor(@Nullable LevelReader var1, @Nullable BlockPos var2);

    public boolean containsFood() {
        return this.fluid.isFood();
    }

    public void load(CompoundTag compound) {
        if (compound.m_128441_("FluidHolder")) {
            CompoundTag cmp = compound.m_128469_("FluidHolder");
            this.setCount(cmp.m_128451_("Count"));
            String id = cmp.m_128461_("Fluid");
            SoftFluid sf = SoftFluidRegistry.get(id);
            this.setFluid(sf, cmp.m_128469_("NBT"));
        }
        if (this.fluid == null) {
            this.fluid = SoftFluidRegistry.getEmpty();
        }
    }

    public CompoundTag save(CompoundTag compound) {
        ResourceLocation id;
        CompoundTag cmp = new CompoundTag();
        cmp.m_128405_("Count", this.count);
        if (this.fluid == null) {
            this.fluid = SoftFluidRegistry.getEmpty();
        }
        if ((id = Utils.getID(this.fluid)) == null) {
            Moonlight.LOGGER.warn("Failed to save fluid in container: {} is not registered", (Object)this.fluid);
            cmp.m_128359_("Fluid", SoftFluidRegistry.EMPTY_ID.toString());
        } else {
            cmp.m_128359_("Fluid", id.toString());
        }
        cmp.m_128405_("CachedColor", this.getTintColor(null, null));
        if (this.nbt != null && !this.nbt.m_128456_()) {
            cmp.m_128365_("NBT", (Tag)this.nbt);
        }
        compound.m_128365_("FluidHolder", (Tag)cmp);
        return compound;
    }

    public boolean tryDrinkUpFluid(Player player, Level world) {
        if (!this.isEmpty() && this.containsFood() && this.fluid.getFoodProvider().consume(player, world, this::applyNBTtoItemStack)) {
            this.shrink(1);
            return true;
        }
        return false;
    }

    protected static boolean areNbtEquals(CompoundTag nbt, CompoundTag nbt1) {
        if ((nbt == null || nbt.m_128456_()) && (nbt1 == null || nbt1.m_128456_())) {
            return true;
        }
        if (nbt == null || nbt1 == null) {
            return false;
        }
        if (nbt1.m_128441_(POTION_TYPE_KEY) && !nbt.m_128441_(POTION_TYPE_KEY)) {
            CompoundTag n1 = nbt1.m_6426_();
            n1.m_128473_(POTION_TYPE_KEY);
            return n1.equals((Object)nbt);
        }
        if (nbt.m_128441_(POTION_TYPE_KEY) && !nbt1.m_128441_(POTION_TYPE_KEY)) {
            CompoundTag n = nbt.m_6426_();
            n.m_128473_(POTION_TYPE_KEY);
            return n.equals((Object)nbt1);
        }
        return nbt1.equals((Object)nbt);
    }

    protected void applyNBTtoItemStack(ItemStack stack) {
        List<String> nbtKey = this.fluid.getNbtKeyFromItem();
        if (this.nbt != null && !this.nbt.m_128456_()) {
            CompoundTag newCom = new CompoundTag();
            for (String s : nbtKey) {
                Tag c = this.nbt.m_128423_(s);
                if (c == null || s.equals(POTION_TYPE_KEY)) continue;
                newCom.m_128365_(s, c);
            }
            if (!newCom.m_128456_()) {
                stack.m_41751_(newCom);
            }
        }
    }

    protected void addPotionTag(Item i, CompoundTag com) {
        String type = "REGULAR";
        if (i instanceof SplashPotionItem) {
            type = "SPLASH";
        } else if (i instanceof LingeringPotionItem) {
            type = "LINGERING";
        }
        com.m_128359_(POTION_TYPE_KEY, type);
    }

    public static int getLiquidCountFromItem(Item i) {
        if (i == Items.f_42590_) {
            return 1;
        }
        if (i == Items.f_42399_) {
            return 2;
        }
        if (i == Items.f_42446_) {
            return 4;
        }
        return 0;
    }
}

