/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class VertexUtil {
    private static int getFormatLength() {
        return DefaultVertexFormat.f_85811_.m_86017_();
    }

    public static List<BakedQuad> swapSprite(List<BakedQuad> quads, TextureAtlasSprite sprite) {
        ArrayList<BakedQuad> newList = new ArrayList<BakedQuad>();
        for (BakedQuad q : quads) {
            newList.add(VertexUtil.swapSprite(q, sprite));
        }
        return newList;
    }

    public static BakedQuad swapSprite(BakedQuad q, TextureAtlasSprite sprite) {
        TextureAtlasSprite oldSprite = q.m_173410_();
        int formatLength = VertexUtil.getFormatLength();
        int[] v = Arrays.copyOf(q.m_111303_(), q.m_111303_().length);
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalU = Float.intBitsToFloat(v[i * formatLength + 4]);
            float originalV = Float.intBitsToFloat(v[i * formatLength + 5]);
            v[i * formatLength + 4] = Float.floatToIntBits(originalU - oldSprite.m_118409_() + sprite.m_118409_());
            v[i * formatLength + 5] = Float.floatToIntBits(originalV - oldSprite.m_118411_() + sprite.m_118411_());
        }
        return new BakedQuad(v, q.m_111305_(), q.m_111306_(), sprite, q.m_111307_());
    }

    public static void transformVertices(int[] v, Matrix3f transform) {
        int formatLength = VertexUtil.getFormatLength();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]) - 0.5f;
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]) - 0.5f;
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]) - 0.5f;
            Vector3f vector3f = new Vector3f(originalX, originalY, originalZ);
            vector3f.mul((Matrix3fc)transform);
            v[i * formatLength] = Float.floatToIntBits(vector3f.x() + 0.5f);
            v[i * formatLength + 1] = Float.floatToIntBits(vector3f.y() + 0.5f);
            v[i * formatLength + 2] = Float.floatToIntBits(vector3f.z() + 0.5f);
        }
    }

    public static void transformVertices(int[] v, PoseStack stack, TextureAtlasSprite sprite) {
        Vector4f vector4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vector4f.mul((Matrix4fc)stack.m_85850_().m_252922_());
        VertexUtil.moveVertices(v, vector4f.x(), vector4f.y(), vector4f.z());
    }

    public static void rotateVerticesY(int[] v, TextureAtlasSprite sprite, Rotation rot) {
        Matrix3f matrix = rot.m_55948_().m_253203_();
        VertexUtil.transformVertices(v, matrix);
    }

    public static void moveVertices(int[] v, Direction dir, float amount) {
        int formatLength = VertexUtil.getFormatLength();
        int axis = dir.m_122434_().ordinal();
        float step = amount * (float)dir.m_122421_().m_122540_();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float original = Float.intBitsToFloat(v[i * formatLength + axis]);
            v[i * formatLength + axis] = Float.floatToIntBits(original + step);
        }
    }

    public static void moveVertices(int[] v, float x, float y, float z) {
        int formatLength = VertexUtil.getFormatLength();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]);
            v[i * formatLength] = Float.floatToIntBits(originalX + x);
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]);
            v[i * formatLength + 1] = Float.floatToIntBits(originalY + y);
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]);
            v[i * formatLength + 2] = Float.floatToIntBits(originalZ + z);
        }
    }

    public static void scaleVertices(int[] v, float scale) {
        int formatLength = VertexUtil.getFormatLength();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]);
            v[i * formatLength] = Float.floatToIntBits(originalX * scale);
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]);
            v[i * formatLength + 1] = Float.floatToIntBits(originalY * scale);
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]);
            v[i * formatLength + 2] = Float.floatToIntBits(originalZ * scale);
        }
    }
}

