/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.CustomGeometry;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.client.model.RetexturedModel;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;

public class RetexturedModelLoader
implements CustomModelLoader {
    @Override
    public CustomGeometry deserialize(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        ResourceLocation parentLoc = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"parent_model"));
        ResourceLocation parent = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"parent_block"));
        Optional b = BuiltInRegistries.f_256975_.m_6612_(parent);
        if (b.isEmpty()) {
            throw new JsonParseException("Could not find block with id " + parent);
        }
        return new Geometry((Block)b.get(), parentLoc);
    }

    private static class Geometry
    implements CustomGeometry {
        private final ResourceLocation parentLoc;
        private final Block parentBlock;

        private Geometry(Block parentBlock, ResourceLocation model) {
            this.parentLoc = model;
            this.parentBlock = parentBlock;
        }

        @Override
        public CustomBakedModel bake(ModelBaker modelBaker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ResourceLocation location) {
            BlockModel myModel = (BlockModel)modelBaker.m_245361_(location);
            UnbakedModel parentModel = modelBaker.m_245361_(this.parentLoc);
            parentModel.m_5500_(arg_0 -> ((ModelBaker)modelBaker).m_245361_(arg_0));
            HashMap<Direction, List<String>> spriteOrder = new HashMap<Direction, List<String>>();
            if (parentModel instanceof BlockModel) {
                BlockModel bm = (BlockModel)parentModel;
                for (BlockElement blockElement : bm.m_111436_()) {
                    for (Direction direction : blockElement.f_111310_.keySet()) {
                        BlockElementFace blockElementFace = (BlockElementFace)blockElement.f_111310_.get(direction);
                        if (blockElementFace.f_111354_ == null) {
                            spriteOrder.computeIfAbsent(null, d -> new ArrayList()).add(blockElementFace.f_111356_);
                            continue;
                        }
                        spriteOrder.computeIfAbsent(direction, d -> new ArrayList()).add(blockElementFace.f_111356_);
                    }
                }
            }
            Function<String, TextureAtlasSprite> newSpriteResolver = s -> (TextureAtlasSprite)spriteGetter.apply(myModel.m_111480_(s));
            return new RetexturedModel(this.parentBlock, newSpriteResolver, spriteOrder, myModel.m_111476_());
        }
    }
}

