/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.model;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RetexturedModel
implements CustomBakedModel {
    private static final Map<ModelResourceLocation, RetexturedModel> parentCache = new Object2ObjectLinkedOpenHashMap();
    private static final Map<BlockState, Map<Direction, List<BakedQuad>>> modelCache = new IdentityHashMap<BlockState, Map<Direction, List<BakedQuad>>>();
    private final Block parent;
    private final boolean ambientOcclusion;
    private Function<String, TextureAtlasSprite> newSpriteGetter;
    private Map<Direction, List<String>> spriteOrder;
    private final TextureAtlasSprite particle;

    RetexturedModel(Block parent, Function<String, TextureAtlasSprite> newSpriteGetter, Map<Direction, List<String>> spriteOrder, boolean ambientOcclusion) {
        this.parent = parent;
        this.newSpriteGetter = newSpriteGetter;
        this.spriteOrder = spriteOrder;
        this.particle = newSpriteGetter.apply("#particle");
        this.ambientOcclusion = ambientOcclusion;
    }

    @Override
    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData extraModelData) {
        Map map;
        List v;
        if (state == null) {
            state = this.parent.m_49966_();
        }
        if ((v = (List)(map = modelCache.computeIfAbsent(state, s -> new HashMap())).get(side)) == null) {
            if (this.spriteOrder == null || !this.spriteOrder.containsKey(side)) {
                map.put(side, List.of());
                return List.of();
            }
            BlockModelShaper shaper = Minecraft.m_91087_().m_91304_().m_119430_();
            BlockState parentState = this.parent.m_152465_(state);
            BakedModel parentModel = shaper.m_110893_(parentState);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            try {
                List originalQuads = parentModel.m_213637_(parentState, side, rand);
                if (!originalQuads.isEmpty()) {
                    List<String> list = this.spriteOrder.get(side);
                    int i = 0;
                    for (BakedQuad q : originalQuads) {
                        String textureName = list.get(i);
                        quads.add(VertexUtil.swapSprite(q, this.newSpriteGetter.apply(textureName)));
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.spriteOrder.remove(side);
            if (map.size() == 7) {
                this.newSpriteGetter = null;
            }
            if (this.spriteOrder.isEmpty()) {
                this.spriteOrder = null;
            }
            map.put(side, quads);
            return quads;
        }
        return v;
    }

    @Override
    public TextureAtlasSprite getBlockParticle(ExtraModelData extraModelData) {
        return this.particle;
    }

    public boolean m_7541_() {
        return this.ambientOcclusion;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

