/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.CustomGeometry;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;

public class NestedModelLoader
implements CustomModelLoader {
    private final Function<BakedModel, CustomBakedModel> factory;
    private final String path;

    public NestedModelLoader(String modelPath, Function<BakedModel, CustomBakedModel> bakedModelFactory) {
        this.factory = bakedModelFactory;
        this.path = modelPath;
    }

    @Override
    public CustomGeometry deserialize(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        JsonElement j = json.get(this.path);
        if (j.isJsonPrimitive()) {
            return new GeometryIndirect(ResourceLocation.m_135820_((String)j.getAsString()));
        }
        return new GeometryDirect((UnbakedModel)ClientHelper.parseBlockModel(j));
    }

    private CustomBakedModel getCustomBakedModel(ModelBaker modelBaker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ResourceLocation location, UnbakedModel model, ResourceLocation modelLoc) {
        model.m_5500_(arg_0 -> ((ModelBaker)modelBaker).m_245361_(arg_0));
        BakedModel bakedModel = model.m_7611_(modelBaker, spriteGetter, transform, modelLoc);
        if (model == modelBaker.m_245361_((ResourceLocation)ModelBakery.f_119230_)) {
            throw new JsonParseException("Found missing model for location " + modelLoc + " while parsing nested model " + location);
        }
        return this.factory.apply(bakedModel);
    }

    private class GeometryIndirect
    implements CustomGeometry {
        private final ResourceLocation modelLoc;

        private GeometryIndirect(ResourceLocation model) {
            this.modelLoc = model;
        }

        @Override
        public CustomBakedModel bake(ModelBaker modelBaker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ResourceLocation location) {
            UnbakedModel model = modelBaker.m_245361_(this.modelLoc);
            return NestedModelLoader.this.getCustomBakedModel(modelBaker, spriteGetter, transform, location, model, this.modelLoc);
        }
    }

    private class GeometryDirect
    implements CustomGeometry {
        private final UnbakedModel model;

        private GeometryDirect(UnbakedModel model) {
            this.model = model;
        }

        @Override
        public CustomBakedModel bake(ModelBaker modelBaker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ResourceLocation location) {
            return NestedModelLoader.this.getCustomBakedModel(modelBaker, spriteGetter, transform, location, this.model, location);
        }
    }
}

