/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set.fabric;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import net.mehvahdjukaar.moonlight.api.platform.fabric.RegHelperImpl;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class BlockSetInternalImpl {
    private static boolean hasFilledBlockSets = false;
    public static final Map<class_2378<?>, Map<Class<? extends BlockType>, LateRegQueue<?, ?>>> QUEUES = new HashMap();

    public static boolean hasFilledBlockSets() {
        return hasFilledBlockSets;
    }

    public static <T extends BlockType, E> void addDynamicRegistration(BlockSetAPI.BlockTypeRegistryCallback<E, T> registrationFunction, Class<T> blockType, class_2378<E> registry) {
        LateRegQueue r = QUEUES.computeIfAbsent(registry, b -> new LinkedHashMap()).computeIfAbsent(blockType, b -> new LateRegQueue(blockType, registry));
        r.add(registrationFunction);
    }

    public static void registerEntries() {
        BlockSetInternal.initializeBlockSets();
        BlockSetInternal.getRegistries().forEach(BlockTypeRegistry::onItemInit);
        ArrayList<class_2378> available = new ArrayList<class_2378>(QUEUES.keySet().stream().toList());
        available.sort(Comparator.comparingInt(a -> RegHelperImpl.REG_PRIORITY.indexOf(a.method_30517())));
        for (class_2378 r : available) {
            Map<Class<BlockType>, LateRegQueue<?, ?>> blockQueue = QUEUES.get(r);
            if (blockQueue == null) continue;
            for (Map.Entry<Class<BlockType>, LateRegQueue<?, ?>> e : blockQueue.entrySet()) {
                e.getValue().registerEntries();
            }
            QUEUES.remove(r);
        }
        hasFilledBlockSets = true;
    }

    private static class LateRegQueue<T extends BlockType, E> {
        final Class<T> blockType;
        final Queue<BlockSetAPI.BlockTypeRegistryCallback<E, T>> queue = new ArrayDeque<BlockSetAPI.BlockTypeRegistryCallback<E, T>>();
        final class_2378<E> registry;

        public LateRegQueue(Class<T> blockType, class_2378<E> registry) {
            this.blockType = blockType;
            this.registry = registry;
        }

        public void add(BlockSetAPI.BlockTypeRegistryCallback<E, T> callback) {
            this.queue.add(callback);
        }

        public void registerEntries() {
            this.queue.forEach(a -> a.accept((n, i) -> class_2378.method_10230(this.registry, (class_2960)n, (Object)i), BlockSetAPI.getBlockSet(this.blockType).getValues()));
        }
    }
}

