/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.map.CustomDataHolder;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.MapHelper;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundSyncCustomMapDecorationMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.minecraft.class_1657;
import net.minecraft.class_17;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_22.class})
public abstract class MapDataMixin
extends class_18
implements ExpandedMapData {
    @Final
    @Shadow
    public byte field_119;
    @Final
    @Shadow
    Map<String, class_20> field_117;
    @Final
    @Shadow
    public class_5321<class_1937> field_118;
    @Final
    @Shadow
    public boolean field_17403;
    @Shadow
    @Final
    private Map<String, class_17> field_123;
    @Shadow
    @Final
    public int field_116;
    @Shadow
    @Final
    public int field_115;
    @Unique
    public Map<String, CustomMapDecoration> customDecorations = Maps.newLinkedHashMap();
    @Unique
    private final Map<String, MapBlockMarker<?>> customMapMarkers = Maps.newHashMap();
    @Unique
    public final Map<class_2960, CustomDataHolder.Instance<?>> customData = new HashMap();

    @Override
    public Map<class_2960, CustomDataHolder.Instance<?>> getCustomData() {
        return this.customData;
    }

    @Override
    public Map<String, CustomMapDecoration> getCustomDecorations() {
        return this.customDecorations;
    }

    @Override
    public Map<String, MapBlockMarker<?>> getCustomMarkers() {
        return this.customMapMarkers;
    }

    @Override
    public int getVanillaDecorationSize() {
        return this.field_117.size();
    }

    @Override
    public <D extends CustomMapDecoration> void addCustomDecoration(MapBlockMarker<D> marker) {
        D decoration = marker.createDecorationFromMarker(this.field_119, this.field_116, this.field_115, this.field_118, this.field_17403);
        if (decoration != null) {
            this.customDecorations.put(marker.getMarkerId(), (CustomMapDecoration)decoration);
        }
    }

    @Override
    public class_22 copy() {
        class_22 newData = class_22.method_32371((class_2487)this.method_75(new class_2487()));
        newData.method_80();
        return newData;
    }

    @Override
    public void resetCustomDecoration() {
        for (String key : this.customMapMarkers.keySet()) {
            this.customDecorations.remove(key);
            this.customMapMarkers.remove(key);
        }
        for (String key : this.field_123.keySet()) {
            this.field_123.remove(key);
            this.field_117.remove(key);
        }
    }

    @Override
    public boolean toggleCustomDecoration(class_1936 world, class_2338 pos) {
        if (world.method_8608()) {
            List<MapBlockMarker<?>> markers = MapDecorationRegistry.getMarkersFromWorld((class_1922)world, pos);
            return !markers.isEmpty();
        }
        double d0 = (double)pos.method_10263() + 0.5;
        double d1 = (double)pos.method_10260() + 0.5;
        int i = 1 << this.field_119;
        double d2 = (d0 - (double)this.field_116) / (double)i;
        double d3 = (d1 - (double)this.field_115) / (double)i;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            List<MapBlockMarker<?>> markers = MapDecorationRegistry.getMarkersFromWorld((class_1922)world, pos);
            boolean changed = false;
            for (MapBlockMarker<?> marker : markers) {
                if (marker == null) continue;
                String id = marker.getMarkerId();
                if (this.customMapMarkers.containsKey(id) && this.customMapMarkers.get(id).equals(marker)) {
                    this.customMapMarkers.remove(id);
                    this.customDecorations.remove(id);
                } else {
                    this.customMapMarkers.put(id, marker);
                    this.addCustomDecoration(marker);
                }
                changed = true;
            }
            if (changed) {
                this.method_80();
                return true;
            }
        }
        return false;
    }

    @Inject(method={"locked"}, at={@At(value="RETURN")})
    public void locked(CallbackInfoReturnable<class_22> cir) {
        class_22 data = (class_22)cir.getReturnValue();
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            expandedMapData.getCustomMarkers().putAll(this.getCustomMarkers());
            expandedMapData.getCustomDecorations().putAll(this.getCustomDecorations());
        }
    }

    @Inject(method={"scaled"}, at={@At(value="RETURN")})
    public void scaled(CallbackInfoReturnable<class_22> cir) {
        class_22 data = (class_22)cir.getReturnValue();
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            expandedMapData.getCustomData().putAll(this.customData);
        }
    }

    @Inject(method={"tickCarriedBy"}, at={@At(value="TAIL")})
    public void tickCarriedBy(class_1657 player, class_1799 stack, CallbackInfo ci) {
        class_2487 tag = stack.method_7969();
        if (tag != null) {
            if (tag.method_10573("CustomDecorations", 9)) {
                class_2499 listTag = tag.method_10554("CustomDecorations", 10);
                for (int j = 0; j < listTag.size(); ++j) {
                    class_2487 com = listTag.method_10602(j);
                    if (this.field_117.containsKey(com.method_10558("id"))) continue;
                    String name = com.method_10558("type");
                    MapDecorationType<CustomMapDecoration, ?> type = MapDecorationRegistry.get(name);
                    if (type != null) {
                        MapBlockMarker<? extends CustomMapDecoration> dummy = type.getDefaultMarker(new class_2338(com.method_10550("x"), 64, com.method_10550("z")));
                        this.addCustomDecoration(dummy);
                        continue;
                    }
                    Moonlight.LOGGER.warn("Failed to load map decoration " + name + ". Skipping it");
                }
            }
            Integer mapId = MapHelper.getMapId(stack, player, this);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (mapId != null) {
                    ModMessages.CHANNEL.sendToClientPlayer(serverPlayer, new ClientBoundSyncCustomMapDecorationMessage(mapId, this.field_119, this.field_17403, this.customDecorations.values().toArray(new CustomMapDecoration[0]), this.customData.values().toArray(new CustomDataHolder.Instance[0])));
                }
            }
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private static void load(class_2487 compound, CallbackInfoReturnable<class_22> cir) {
        class_22 data = (class_22)cir.getReturnValue();
        if (compound.method_10545("customMarkers") && data instanceof ExpandedMapData) {
            ExpandedMapData mapData = (ExpandedMapData)data;
            class_2499 listNBT = compound.method_10554("customMarkers", 10);
            for (int j = 0; j < listNBT.size(); ++j) {
                MapBlockMarker<?> marker = MapDecorationRegistry.readWorldMarker(listNBT.method_10602(j));
                if (marker == null) continue;
                mapData.getCustomMarkers().put(marker.getMarkerId(), marker);
                mapData.addCustomDecoration(marker);
            }
            Map<class_2960, CustomDataHolder.Instance<?>> customData = mapData.getCustomData();
            customData.clear();
            MapDecorationRegistry.CUSTOM_MAP_DATA_TYPES.forEach((s, o) -> {
                CustomDataHolder.Instance i = o.create(compound);
                if (i != null) {
                    customData.put((class_2960)s, i);
                }
            });
        }
    }

    @Inject(method={"save"}, at={@At(value="RETURN")})
    public void save(class_2487 tag, CallbackInfoReturnable<class_2487> cir) {
        class_2487 com = (class_2487)cir.getReturnValue();
        class_2499 listNBT = new class_2499();
        for (MapBlockMarker<?> marker : this.customMapMarkers.values()) {
            class_2487 com2 = new class_2487();
            com2.method_10566(marker.getTypeId(), (class_2520)marker.saveToNBT(new class_2487()));
            listNBT.add((Object)com2);
        }
        com.method_10566("customMarkers", (class_2520)listNBT);
        this.customData.forEach((s, o) -> o.save(tag));
    }

    @Inject(method={"checkBanners"}, at={@At(value="TAIL")})
    public void checkBanners(class_1922 world, int x, int z, CallbackInfo ci) {
        Iterator<MapBlockMarker<?>> iterator = this.customMapMarkers.values().iterator();
        while (iterator.hasNext()) {
            MapBlockMarker<?> marker = iterator.next();
            if (marker.getPos().method_10263() != x || marker.getPos().method_10260() != z) continue;
            Object newMarker = marker.getType().getWorldMarkerFromWorld(world, marker.getPos());
            String id = marker.getMarkerId();
            if (newMarker == null) {
                iterator.remove();
                this.customDecorations.remove(id);
                continue;
            }
            if (!Objects.equals(id, ((MapBlockMarker)newMarker).getMarkerId()) || !marker.shouldUpdate((MapBlockMarker<?>)newMarker)) continue;
            ((MapBlockMarker)newMarker).updateDecoration(this.customDecorations.get(id));
        }
    }
}

