/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.math.colors;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.util.math.colors.ColorSpaces;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HCLColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HCLVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSLColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LUVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.XYZColor;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public abstract class BaseColor<T extends BaseColor<T>> {
    public static final Codec<Integer> CODEC = Codec.either((Codec)Codec.INT, (Codec)Codec.STRING.flatXmap(BaseColor::isValidString, BaseColor::isValidString)).xmap(either -> (Integer)either.map(i -> i, s -> Integer.parseUnsignedInt(s, 16)), i -> Either.right((Object)("#" + Integer.toHexString(i))));
    protected final float v0;
    protected final float v1;
    protected final float v2;
    protected final float v3;

    protected BaseColor(float v0, float v1, float v2, float v3) {
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
    }

    public float distTo(T other) {
        return (float)Math.sqrt((this.v0 - ((BaseColor)other).v0) * (this.v0 - ((BaseColor)other).v0) + (this.v1 - ((BaseColor)other).v1) * (this.v1 - ((BaseColor)other).v1) + (this.v2 - ((BaseColor)other).v2) * (this.v2 - ((BaseColor)other).v2));
    }

    public T mixWith(T color) {
        return this.mixWith(color, 0.5f);
    }

    public T mixWith(T color, float bias) {
        return color;
    }

    public abstract T multiply(T var1, float var2, float var3, float var4, float var5);

    public static <C extends BaseColor<C>> C mixColors(List<C> colors) {
        int size = colors.size();
        BaseColor mixed = (BaseColor)colors.get(0);
        for (int i = 1; i < size; ++i) {
            mixed = mixed.mixWith((BaseColor)colors.get(i), 1.0f / ((float)i + 1.0f));
        }
        return (C)mixed;
    }

    public static <C extends BaseColor<C>> C mixColors(C ... colors) {
        return BaseColor.mixColors(List.of(colors));
    }

    public abstract RGBColor asRGB();

    public HSLColor asHSL() {
        HSLColor c;
        BaseColor baseColor = this;
        return baseColor instanceof HSLColor ? (c = (HSLColor)baseColor) : ColorSpaces.RGBtoHSL(this.asRGB());
    }

    public HSVColor asHSV() {
        HSVColor c;
        BaseColor baseColor = this;
        return baseColor instanceof HSVColor ? (c = (HSVColor)baseColor) : ColorSpaces.RGBtoHSV(this.asRGB());
    }

    public XYZColor asXYZ() {
        XYZColor c;
        BaseColor baseColor = this;
        return baseColor instanceof XYZColor ? (c = (XYZColor)baseColor) : ColorSpaces.RGBtoXYZ(this.asRGB());
    }

    public LABColor asLAB() {
        LABColor c;
        BaseColor baseColor = this;
        return baseColor instanceof LABColor ? (c = (LABColor)baseColor) : ColorSpaces.XYZtoLAB(this.asXYZ());
    }

    public HCLColor asHCL() {
        HCLColor c;
        BaseColor baseColor = this;
        return baseColor instanceof HCLColor ? (c = (HCLColor)baseColor) : ColorSpaces.LABtoHCL(this.asLAB());
    }

    public LUVColor asLUV() {
        LUVColor c;
        BaseColor baseColor = this;
        return baseColor instanceof LUVColor ? (c = (LUVColor)baseColor) : ColorSpaces.XYZtoLUV(this.asXYZ());
    }

    public HCLVColor asHCLV() {
        HCLVColor c;
        BaseColor baseColor = this;
        return baseColor instanceof HCLVColor ? (c = (HCLVColor)baseColor) : ColorSpaces.LUVtoHCLV(this.asLUV());
    }

    public static float weightedAverageAngles(float a, float b, float bias) {
        return class_3532.method_17821((float)bias, (float)(a * 360.0f), (float)(b * 360.0f)) / 360.0f;
    }

    protected static float averageAngles(Float ... angles) {
        float x = 0.0f;
        float y = 0.0f;
        Float[] floatArray = angles;
        int n = floatArray.length;
        for (int i = 0; i < n; ++i) {
            float a = floatArray[i].floatValue();
            assert (a >= 0.0f && a <= 1.0f);
            x = (float)((double)x + Math.cos((float)((double)a * Math.PI * 2.0)));
            y = (float)((double)y + Math.sin((float)((double)a * Math.PI * 2.0)));
        }
        double a = Math.atan2(y, x) / (Math.PI * 2);
        return (float)a;
    }

    public abstract T fromRGB(RGBColor var1);

    @NotNull
    private static DataResult<String> isValidString(String s) {
        String st = s;
        if (s.startsWith("0x")) {
            st = s.substring(2);
        } else if (s.startsWith("#")) {
            st = s.substring(1);
        }
        try {
            Integer.parseUnsignedInt(st, 16);
            return DataResult.success((Object)st);
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Invalid color format. Must be in hex format (0xff00ff, #ff00ff, ff00ff) or integer value");
        }
    }
}

