/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3274;
import net.minecraft.class_3288;
import net.minecraft.class_5250;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7699;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicResourcePack
implements class_3262 {
    private static final List<DynamicResourcePack> INSTANCES = new ArrayList<DynamicResourcePack>();
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final boolean hidden;
    protected final boolean fixed;
    protected final class_3288.class_3289 position;
    protected final class_3264 packType;
    protected final class_3288.class_7679 info;
    protected final class_3272 metadata;
    protected final class_2561 title;
    protected final class_2960 resourcePackName;
    protected final Set<String> namespaces = new HashSet<String>();
    protected final Map<class_2960, byte[]> resources = new ConcurrentHashMap<class_2960, byte[]>();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();
    protected final String mainNamespace;
    protected boolean generateDebugResources;
    protected boolean canBeCleared;
    protected Set<class_2960> staticResources = new HashSet<class_2960>();
    boolean addToStatic = false;

    @ApiStatus.Internal
    public static void clearAfterReload(boolean clientSide) {
        for (DynamicResourcePack p : INSTANCES) {
            if (p.packType == class_3264.field_14188 != clientSide) continue;
            p.clearContent();
        }
    }

    protected DynamicResourcePack(class_2960 name, class_3264 type) {
        this(name, type, class_3288.class_3289.field_14280, false, false);
    }

    protected DynamicResourcePack(class_2960 name, class_3264 type, class_3288.class_3289 position, boolean fixed, boolean hidden) {
        this.packType = type;
        class_5250 component = class_2561.method_43471((String)LangBuilder.getReadableName(name.method_12836() + "_dynamic_resources"));
        this.resourcePackName = name;
        this.mainNamespace = name.method_12836();
        this.namespaces.add(name.method_12836());
        this.title = class_2561.method_43471((String)LangBuilder.getReadableName(name.toString()));
        this.position = position;
        this.fixed = fixed;
        this.hidden = hidden;
        this.metadata = new class_3272((class_2561)component, class_155.method_16673().method_48017(type));
        this.info = new class_3288.class_7679(this.metadata.method_14423(), this.metadata.method_14424(), class_7699.method_45397());
        this.generateDebugResources = PlatHelper.isDev();
    }

    public void clearOnReload(boolean canBeCleared) {
        this.canBeCleared = canBeCleared;
    }

    public void markNotClearable(class_2960 staticResources) {
        this.staticResources.add(staticResources);
    }

    public void setGenerateDebugResources(boolean generateDebugResources) {
        this.generateDebugResources = generateDebugResources;
    }

    public void addNamespaces(String ... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public String method_14409() {
        return this.title.getString();
    }

    public String toString() {
        return this.method_14409();
    }

    public void registerPack() {
        PlatHelper.registerResourcePack(this.packType, () -> class_3288.method_14456((String)this.method_14409(), (class_2561)this.getTitle(), (boolean)true, s -> this, (class_3288.class_7679)this.info, (class_3264)this.packType, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)this.fixed, (class_5352)class_5352.field_25348));
        INSTANCES.add(this);
    }

    public Set<String> method_14406(class_3264 packType) {
        return this.namespaces;
    }

    public <T> T method_14407(class_3270<T> serializer) {
        return (T)(serializer instanceof class_3274 ? this.metadata : null);
    }

    public void addRootResource(String name, byte[] resource) {
        this.rootResources.put(name, resource);
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... strings) {
        String fileName = String.join((CharSequence)"/", strings);
        return () -> new ByteArrayInputStream(this.rootResources.get(fileName));
    }

    public void method_14408(class_3264 packType, String namespace, String id, class_3262.class_7664 output) {
        if (packType == this.packType && this.namespaces.contains(namespace)) {
            this.resources.entrySet().stream().filter(r -> ((class_2960)r.getKey()).method_12836().equals(namespace) && ((class_2960)r.getKey()).method_12832().startsWith(id)).forEach(r -> output.accept((Object)((class_2960)r.getKey()), () -> new ByteArrayInputStream((byte[])r.getValue())));
        }
    }

    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        byte[] res = this.resources.get(id);
        if (res != null) {
            return () -> {
                if (type != this.packType) {
                    throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.resourcePackName));
                }
                return new ByteArrayInputStream(res);
            };
        }
        return null;
    }

    public void close() {
    }

    public FileNotFoundException makeFileNotFoundException(String path) {
        return new FileNotFoundException(String.format("'%s' in ResourcePack '%s'", path, this.resourcePackName));
    }

    protected void addBytes(class_2960 path, byte[] bytes) {
        this.namespaces.add(path.method_12836());
        this.resources.put(path, bytes);
        if (this.addToStatic) {
            this.markNotClearable(path);
        }
        if (this.generateDebugResources) {
            try {
                Path p = Paths.get("debug", "generated_resource_pack").resolve(path.method_12836() + "/" + path.method_12832());
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                Files.write(p, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addResource(StaticResource resource) {
        this.addBytes(resource.location, resource.data);
    }

    private void addJson(class_2960 path, JsonElement json) {
        try {
            this.addBytes(path, RPUtils.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            LOGGER.error("Failed to write JSON {} to resource pack {}.", (Object)path, (Object)this.resourcePackName, (Object)e);
        }
    }

    public void addJson(class_2960 location, JsonElement json, ResType resType) {
        this.addJson(resType.getPath(location), json);
    }

    public void addBytes(class_2960 location, byte[] bytes, ResType resType) {
        this.addBytes(resType.getPath(location), bytes);
    }

    public class_3264 getPackType() {
        return this.packType;
    }

    public void clearContent() {
        if (this.canBeCleared) {
            for (class_2960 r : this.resources.keySet()) {
                if (this.staticResources.contains(r)) continue;
                this.resources.remove(r);
            }
        }
    }
}

