/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Stopwatch;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.events.EarlyPackReloadEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.integration.ModernFixCompat;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.VanillaResourceManager;
import net.minecraft.class_2960;
import net.minecraft.class_3283;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class DynResourceGenerator<T extends DynamicResourcePack>
implements class_3302 {
    private static final boolean MODERN_FIX = PlatHelper.isModLoaded("modernfix");
    public final T dynamicPack;
    private boolean hasBeenInitialized;

    protected DynResourceGenerator(T pack) {
        this.dynamicPack = pack;
    }

    public void register() {
        ((DynamicResourcePack)this.dynamicPack).registerPack();
        MoonlightEventsHelper.addListener(this::onEarlyReload, EarlyPackReloadEvent.class);
    }

    public abstract Logger getLogger();

    public T getPack() {
        return this.dynamicPack;
    }

    public abstract boolean dependsOnLoadedPacks();

    public abstract void regenerateDynamicAssets(class_3300 var1);

    @Deprecated(forRemoval=true)
    public void generateStaticAssetsOnStartup(class_3300 manager) {
    }

    public final CompletableFuture<Void> method_25931(class_3302.class_4045 stage, class_3300 manager, class_3695 workerProfiler, class_3695 mainProfiler, Executor workerExecutor, Executor mainExecutor) {
        if (PlatHelper.isModLoadingValid()) {
            this.onNormalReload(manager);
        } else {
            Moonlight.LOGGER.error("Cowardly refusing generate assets for a broken mod state");
        }
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> null, workerExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0))).thenAcceptAsync(noResult -> {}, mainExecutor);
    }

    protected void onNormalReload(class_3300 manager) {
    }

    protected void onEarlyReload(EarlyPackReloadEvent event) {
        if (event.type() == ((DynamicResourcePack)this.dynamicPack).packType) {
            try {
                this.reloadResources(event.manager());
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("An error occurred while trying to generate dynamic assets for {}:", this.dynamicPack, (Object)e);
            }
        }
    }

    protected final void reloadResources(class_3300 manager) {
        Stopwatch watch = Stopwatch.createStarted();
        T t = this.dynamicPack;
        if (t instanceof DynamicTexturePack) {
            DynamicTexturePack tp = (DynamicTexturePack)t;
            if (MODERN_FIX) {
                tp.addJsonsToStatic = ModernFixCompat.areLazyResourcesOn();
            }
        }
        boolean resourcePackSupport = this.dependsOnLoadedPacks();
        if (!this.hasBeenInitialized) {
            this.hasBeenInitialized = true;
            ((DynamicResourcePack)this.dynamicPack).addToStatic = true;
            this.generateStaticAssetsOnStartup(manager);
            T t2 = this.dynamicPack;
            if (t2 instanceof DynamicTexturePack) {
                DynamicTexturePack tp = (DynamicTexturePack)t2;
                tp.addPackLogo();
            }
            if (!resourcePackSupport) {
                class_3283 pack = this.getRepository();
                if (pack != null) {
                    VanillaResourceManager vanillaManager = new VanillaResourceManager(pack);
                    this.regenerateDynamicAssets(vanillaManager);
                    vanillaManager.close();
                } else {
                    this.regenerateDynamicAssets(manager);
                }
            }
            ((DynamicResourcePack)this.dynamicPack).addToStatic = false;
        }
        if (resourcePackSupport) {
            this.regenerateDynamicAssets(manager);
        }
        this.getLogger().info("Generated runtime {} for pack {} in: {} ms" + (((DynamicResourcePack)this.dynamicPack).generateDebugResources ? " (debug resource dump on)" : ""), (Object)((DynamicResourcePack)this.dynamicPack).getPackType(), (Object)((DynamicResourcePack)this.dynamicPack).method_14409(), (Object)watch.elapsed().toMillis());
    }

    @Nullable
    protected abstract class_3283 getRepository();

    public boolean alreadyHasAssetAtLocation(class_3300 manager, class_2960 res, ResType type) {
        return this.alreadyHasAssetAtLocation(manager, type.getPath(res));
    }

    public boolean alreadyHasAssetAtLocation(class_3300 manager, class_2960 res) {
        Optional resource = manager.method_14486(res);
        return resource.filter(value -> !value.method_14480().equals(((DynamicResourcePack)this.dynamicPack).method_14409())).isPresent();
    }

    public void addSimilarJsonResource(class_3300 manager, StaticResource resource, String keyword, String replaceWith) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, s -> s.replace(keyword, replaceWith));
    }

    public void addSimilarJsonResource(class_3300 manager, StaticResource resource, Function<String, String> textTransform) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, textTransform, textTransform);
    }

    public void addSimilarJsonResource(class_3300 manager, StaticResource resource, Function<String, String> textTransform, Function<String, String> pathTransform) throws NoSuchElementException {
        class_2960 fullPath = resource.location;
        StringBuilder builder = new StringBuilder();
        String[] partial = fullPath.method_12832().split("/");
        for (int i = 0; i < partial.length; ++i) {
            if (i != 0) {
                builder.append("/");
            }
            if (i == partial.length - 1) {
                builder.append(pathTransform.apply(partial[i]));
                continue;
            }
            builder.append(partial[i]);
        }
        class_2960 newRes = new class_2960(((DynamicResourcePack)this.dynamicPack).resourcePackName.method_12836(), builder.toString());
        if (!this.alreadyHasAssetAtLocation(manager, newRes)) {
            String fullText = new String(resource.data, StandardCharsets.UTF_8);
            fullText = textTransform.apply(fullText);
            ((DynamicResourcePack)this.dynamicPack).addBytes(newRes, fullText.getBytes());
        }
    }

    public void addResourceIfNotPresent(class_3300 manager, StaticResource resource) {
        if (!this.alreadyHasAssetAtLocation(manager, resource.location)) {
            ((DynamicResourcePack)this.dynamicPack).addResource(resource);
        }
    }
}

